/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPLaunchNotice
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPLaunchNotice.class);
    public static final String ELM_LOCALNAME = "notice";
    public static final String ELM_NAME = "launch:notice";
    private static final String ELM_NOTICE_ID = "noticeID";
    private static final String ELM_NOT_AFTER_DATE = "notAfter";
    private static final String ELM_ACCEPTED_DATE = "acceptedDate";
    private static final String ATTR_VALIDATOR_ID = "validatorID";
    String noticeId;
    private String validatorId = null;
    Date notAfterDate;
    Date acceptedDate;

    public EPPLaunchNotice() {
    }

    public EPPLaunchNotice(String aNoticeId, Date aNotAfterDate, Date aAcceptedDate) {
        this.noticeId = aNoticeId;
        this.notAfterDate = aNotAfterDate;
        this.acceptedDate = aAcceptedDate;
    }

    public EPPLaunchNotice(String aNoticeId, Date aNotAfterDate, Date aAcceptedDate, String aValidatorId) {
        this(aNoticeId, aNotAfterDate, aAcceptedDate);
        this.validatorId = aValidatorId;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchNotice clone = (EPPLaunchNotice)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchNotice.encode(Document)");
        }
        if (this.noticeId == null) {
            throw new EPPEncodeException("notice identifier is not set.");
        }
        if (this.notAfterDate == null) {
            throw new EPPEncodeException("not after date is not set.");
        }
        if (this.acceptedDate == null) {
            throw new EPPEncodeException("accepted date is not set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        Element noticeIdElm = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", "launch:noticeID");
        root.appendChild(noticeIdElm);
        Text textNode = aDocument.createTextNode(this.noticeId);
        noticeIdElm.appendChild(textNode);
        if (this.validatorId != null) {
            noticeIdElm.setAttribute(ATTR_VALIDATOR_ID, this.validatorId);
        }
        EPPUtil.encodeTimeInstant(aDocument, root, this.notAfterDate, "urn:ietf:params:xml:ns:launch-1.0", "launch:notAfter");
        EPPUtil.encodeTimeInstant(aDocument, root, this.acceptedDate, "urn:ietf:params:xml:ns:launch-1.0", "launch:acceptedDate");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.noticeId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_NOTICE_ID);
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_NOTICE_ID);
        if (currElm != null && currElm.hasAttribute(ATTR_VALIDATOR_ID)) {
            this.validatorId = currElm.getAttribute(ATTR_VALIDATOR_ID);
            if (this.validatorId != null && this.validatorId.length() == 0) {
                this.validatorId = null;
            }
        } else {
            this.validatorId = null;
        }
        this.notAfterDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_NOT_AFTER_DATE);
        this.acceptedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_ACCEPTED_DATE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchNotice)) {
            cat.error("EPPLaunchNotice.equals(): aObject is not an EPPLaunchNotice");
            return false;
        }
        EPPLaunchNotice other = (EPPLaunchNotice)aObject;
        if (!EqualityUtil.equals(this.noticeId, other.noticeId)) {
            cat.error("EPPLaunchNotice.equals(): noticeId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.validatorId, other.validatorId)) {
            cat.error("EPPLaunchNotice.equals(): validatorId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.notAfterDate, other.notAfterDate)) {
            cat.error("EPPLaunchNotice.equals(): notAfterDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.acceptedDate, other.acceptedDate)) {
            cat.error("EPPLaunchNotice.equals(): acceptedDate not equal");
            return false;
        }
        return true;
    }

    public String getNoticeId() {
        return this.noticeId;
    }

    public void setNoticeId(String aNoticeId) {
        this.noticeId = aNoticeId;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public void setValidatorId(String aValidatorId) {
        this.validatorId = aValidatorId;
    }

    public boolean hasValidatorId() {
        return this.validatorId != null;
    }

    public Date getNotAfterDate() {
        return this.notAfterDate;
    }

    public void setNotAfterDate(Date aNotAfterDate) {
        this.notAfterDate = aNotAfterDate;
    }

    public Date getAcceptedDate() {
        return this.acceptedDate;
    }

    public void setAcceptedDate(Date aAcceptedDate) {
        this.acceptedDate = aAcceptedDate;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:launch-1.0";
    }
}

