/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPIdnTableInfoTable
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPIdnTableInfoTable.class);
    public static final String ELM_LOCALNAME = "table";
    public static final String ELM_NAME = "idnTable:table";
    private static final String ELM_TABLE_NAME = "name";
    private static final String ELM_TYPE = "type";
    private static final String ELM_DESCRIPTION = "description";
    private static final String ELM_UPDATE_DATE = "upDate";
    private static final String ELM_VERSION = "version";
    private static final String ELM_EFFECTIVE_DATE = "effectiveDate";
    private static final String ELM_VARIANT_GEN = "variantGen";
    private static final String ELM_URL = "url";
    private static final String ATTR_LANG = "lang";
    private String name;
    private Type type;
    private String description;
    private String descriptionLang = "en";
    private Date upDate;
    private String version;
    private Date effectiveDate;
    private Boolean variantGen;
    private String url;

    public EPPIdnTableInfoTable() {
    }

    public EPPIdnTableInfoTable(String aName, Type aType, String aDescription, Date aUpdateDate) {
        this.setName(aName);
        this.setType(aType);
        this.setDescription(aDescription);
        this.setUpdateDate(aUpdateDate);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type aType) {
        this.type = aType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public boolean hasDescriptionLang() {
        return this.descriptionLang != null;
    }

    public String getDescriptionLang() {
        return this.descriptionLang;
    }

    public void setDescriptionLang(String aDescriptionLang) {
        this.descriptionLang = aDescriptionLang;
    }

    public Date getUpdateDate() {
        return this.upDate;
    }

    public void setUpdateDate(Date aUpdateDate) {
        this.upDate = aUpdateDate;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String aVersion) {
        this.version = aVersion;
    }

    public boolean hasEffectiveDate() {
        return this.effectiveDate != null;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date aEffectiveDate) {
        this.effectiveDate = aEffectiveDate;
        if (this.effectiveDate != null) {
            this.effectiveDate = EPPUtil.decodeDate(EPPUtil.encodeDate(this.effectiveDate));
        }
    }

    public boolean hasVariantGen() {
        return this.variantGen != null;
    }

    public Boolean getVariantGen() {
        return this.variantGen;
    }

    public void setVariantGen(Boolean aVariantGen) {
        this.variantGen = aVariantGen;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("Undefined name in EPPIdnTableInfoTable");
        }
        if (this.type == null) {
            throw new EPPEncodeException("Undefined type in EPPIdnTableInfoTable");
        }
        if (this.description == null) {
            throw new EPPEncodeException("Undefined description in EPPIdnTableInfoTable");
        }
        if (this.upDate == null) {
            throw new EPPEncodeException("Undefined upDate in EPPIdnTableInfoTable");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:name");
        switch (this.type) {
            case LANGUAGE: {
                EPPUtil.encodeString(aDocument, root, "language", "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:type");
                break;
            }
            case SCRIPT: {
                EPPUtil.encodeString(aDocument, root, "script", "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:type");
            }
        }
        Element descriptionElm = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:description");
        if (this.hasDescriptionLang()) {
            descriptionElm.setAttribute(ATTR_LANG, this.descriptionLang);
        }
        descriptionElm.appendChild(aDocument.createTextNode(this.description));
        root.appendChild(descriptionElm);
        EPPUtil.encodeTimeInstant(aDocument, root, this.upDate, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:upDate");
        EPPUtil.encodeString(aDocument, root, this.version, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:version");
        EPPUtil.encodeDate(aDocument, root, this.effectiveDate, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:effectiveDate");
        EPPUtil.encodeBoolean(aDocument, root, this.variantGen, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:variantGen");
        EPPUtil.encodeString(aDocument, root, this.url, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:url");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_TABLE_NAME);
        String theType = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_TYPE);
        this.type = theType == null ? null : (theType.equals("language") ? Type.LANGUAGE : Type.SCRIPT);
        Element theDescriptionElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_DESCRIPTION);
        if (theDescriptionElm != null) {
            Node textNode = theDescriptionElm.getFirstChild();
            if (textNode != null) {
                this.description = textNode.getNodeValue();
                String theDescriptionLang = theDescriptionElm.getAttribute(ATTR_LANG);
                this.descriptionLang = theDescriptionLang != null && !theDescriptionLang.isEmpty() ? theDescriptionLang : null;
            } else {
                this.description = null;
                this.descriptionLang = null;
            }
        } else {
            this.description = null;
            this.descriptionLang = null;
        }
        this.upDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_UPDATE_DATE);
        this.version = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_VERSION);
        this.effectiveDate = EPPUtil.decodeDate(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_EFFECTIVE_DATE);
        this.variantGen = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_VARIANT_GEN);
        this.url = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_URL);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableInfoTable clone = (EPPIdnTableInfoTable)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableInfoTable)) {
            return false;
        }
        EPPIdnTableInfoTable other = (EPPIdnTableInfoTable)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPIdnTableInfoTable.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.type, (Object)other.type)) {
            cat.error("EPPIdnTableInfoTable.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.description, other.description)) {
            cat.error("EPPIdnTableInfoTable.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.descriptionLang, other.descriptionLang)) {
            cat.error("EPPIdnTableInfoTable.equals(): descriptionLang not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.upDate, other.upDate)) {
            cat.error("EPPIdnTableInfoTable.equals(): upDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.version, other.version)) {
            cat.error("EPPIdnTableInfoTable.equals(): version not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.effectiveDate, other.effectiveDate)) {
            cat.error("EPPIdnTableInfoTable.equals(): effectiveDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.variantGen, other.variantGen)) {
            cat.error("EPPIdnTableInfoTable.equals(): variantGen not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.url, other.url)) {
            cat.error("EPPIdnTableInfoTable.equals(): url not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:idnTable-1.0";
    }

    public static enum Type {
        LANGUAGE,
        SCRIPT;

    }
}

