/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPIdnTableInfoListItem
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPIdnTableInfoListItem.class);
    public static final String ELM_LOCALNAME = "table";
    public static final String ELM_NAME = "idnTable:table";
    private static final String ELM_TABLE_NAME = "name";
    private static final String ELM_UPDATE_DATE = "upDate";
    private String name;
    private Date upDate;

    public EPPIdnTableInfoListItem() {
    }

    public EPPIdnTableInfoListItem(String aName, Date aUpdateDate) {
        this.setName(aName);
        this.setUpdateDate(aUpdateDate);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Date getUpdateDate() {
        return this.upDate;
    }

    public void setUpdateDate(Date aUpdateDate) {
        this.upDate = aUpdateDate;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("Undefined name in EPPIdnTableInfoListItem");
        }
        if (this.upDate == null) {
            throw new EPPEncodeException("Undefined upDate in EPPIdnTableInfoListItem");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:name");
        EPPUtil.encodeTimeInstant(aDocument, root, this.upDate, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:upDate");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_TABLE_NAME);
        this.upDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_UPDATE_DATE);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableInfoListItem clone = (EPPIdnTableInfoListItem)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableInfoListItem)) {
            return false;
        }
        EPPIdnTableInfoListItem other = (EPPIdnTableInfoListItem)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPIdnTableInfoListItem.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.upDate, other.upDate)) {
            cat.error("EPPIdnTableInfoListItem.equals(): upDate not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:idnTable-1.0";
    }
}

