/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPHostPendActionMsg
extends EPPResponse {
    static final String ELM_NAME = "host:panData";
    private static final String ELM_DOMAIN_NAME = "host:name";
    private static final String ELM_PATRID = "host:paTRID";
    private static final String ELM_PENDING_DATE = "host:paDate";
    private static final String ATTR_RESULT = "paResult";
    private static Logger cat = LoggerFactory.getLogger(EPPHostPendActionMsg.class);
    private String name = null;
    private boolean success = false;
    EPPTransId pendingTransId = null;
    private Date pendingDate = null;

    public EPPHostPendActionMsg() {
    }

    public EPPHostPendActionMsg(EPPTransId aTransId, String aName, boolean aSuccess, EPPTransId aPendingTransId, Date aPendingDate) {
        super(aTransId);
        this.name = aName;
        this.success = aSuccess;
        this.setPendingTransId(aPendingTransId);
        this.pendingTransId = aPendingTransId;
        this.pendingDate = aPendingDate;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:host-1.0";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Date getPendingDate() {
        return this.pendingDate;
    }

    public void setPendingDate(Date pendingDate) {
        this.pendingDate = pendingDate;
    }

    public EPPTransId getPendingTransId() {
        return this.pendingTransId;
    }

    public void setPendingTransId(EPPTransId pendingTransId) {
        this.pendingTransId = pendingTransId;
        this.pendingTransId.setRootName("urn:ietf:params:xml:ns:host-1.0", ELM_PATRID);
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostPendActionMsg)) {
            cat.error("EPPHostPendActionMsg.equals(): " + aObject.getClass().getName() + " not EPPHostPendActionMsg instance");
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error("EPPHostPendActionMsg.equals(): super class not equal");
            return false;
        }
        EPPHostPendActionMsg theComp = (EPPHostPendActionMsg)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            cat.error("EPPHostPendActionMsg.equals(): name not equal");
            return false;
        }
        if (this.success != theComp.success) {
            cat.error("EPPHostPendActionMsg.equals(): success not equal");
            return false;
        }
        if (!(this.pendingTransId != null ? this.pendingTransId.equals(theComp.pendingTransId) : theComp.pendingTransId == null)) {
            cat.error("EPPHostPendActionMsg.equals(): pendingTransId not equal");
            return false;
        }
        if (!(this.pendingDate != null ? this.pendingDate.equals(theComp.pendingDate) : theComp.pendingDate == null)) {
            cat.error("EPPHostPendActionMsg.equals(): pendingDate not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPHostPendActionMsg clone = (EPPHostPendActionMsg)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            cat.error("EPPHostPendActionMsg.validateState(): required attribute name is not set");
            throw new EPPCodecException("required attribute name is not set");
        }
        if (this.pendingTransId == null) {
            cat.error("EPPHostPendActionMsg.validateState(): required attribute pendingTransId is not set");
            throw new EPPCodecException("required attribute pendingTransId is not set");
        }
        if (this.pendingDate == null) {
            cat.error("EPPHostPendActionMsg.validateState(): required attribute pendingDate is not set");
            throw new EPPCodecException("required attribute pendingDate is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPHostPendActionMsg.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        root.setAttribute("xmlns:host", "urn:ietf:params:xml:ns:host-1.0");
        Element nameElm = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_DOMAIN_NAME);
        root.appendChild(nameElm);
        if (this.success) {
            nameElm.setAttribute(ATTR_RESULT, "1");
        } else {
            nameElm.setAttribute(ATTR_RESULT, "0");
        }
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        EPPUtil.encodeComp(aDocument, root, this.pendingTransId);
        EPPUtil.encodeTimeInstant(aDocument, root, this.pendingDate, "urn:ietf:params:xml:ns:host-1.0", ELM_PENDING_DATE);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_DOMAIN_NAME);
        this.name = theNameElm.getFirstChild().getNodeValue();
        String resultStr = theNameElm.getAttribute(ATTR_RESULT);
        this.success = resultStr.equals("1");
        this.pendingTransId = (EPPTransId)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_PATRID, EPPTransId.class);
        this.pendingDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_PENDING_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPHostPendActionMsg.decode: " + e);
        }
    }
}

