/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.emailFwd;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPEmailFwdCheckResult
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPEmailFwdCheckResult.class);
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_LANG = "lang";
    private static final String ELM_EMAILFWD_NAME = "emailFwd:name";
    private static final String ELM_EMAILFWD_REASON = "emailFwd:reason";
    static final String ELM_NAME = "emailFwd:cd";
    private static final String VALUE_LANG = "en";
    private boolean available;
    private String language = "en";
    private String name;
    private String reason;

    public EPPEmailFwdCheckResult() {
        this.name = null;
        this.available = true;
    }

    public EPPEmailFwdCheckResult(String aName, boolean aIsAvailable) {
        this.name = aName;
        this.available = aIsAvailable;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPEmailFwdCheckResult clone = null;
        clone = (EPPEmailFwdCheckResult)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_NAME);
        this.available = EPPUtil.decodeBooleanAttr(currElm, ATTR_AVAIL);
        this.name = currElm.getFirstChild().getNodeValue();
        currElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_REASON);
        if (currElm != null) {
            this.reason = currElm.getFirstChild().getNodeValue();
            String lang = currElm.getAttribute(ATTR_LANG);
            if (lang.length() > 0 && !lang.equals(VALUE_LANG)) {
                this.setLanguage(lang);
            }
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("name required attribute is not set");
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_NAME);
        root.appendChild(nameElm);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_AVAIL, this.available);
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        if (this.reason != null) {
            Element reasonElm = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_REASON);
            root.appendChild(reasonElm);
            if (!this.language.equals(VALUE_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPEmailFwdCheckResult)) {
            return false;
        }
        EPPEmailFwdCheckResult theComp = (EPPEmailFwdCheckResult)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error("EPPEmailFwdCheckResult.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.available, theComp.available)) {
            cat.error("EPPEmailFwdCheckResult.equals(): available not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, theComp.reason)) {
            cat.error("EPPEmailFwdCheckResult.equals(): reason not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.language, theComp.language)) {
            cat.error("EPPEmailFwdCheckResult.equals(): language not equal");
            return false;
        }
        return true;
    }

    public String getEmailFwdReason() {
        return this.reason;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setEmailFwdReason(String aReason) {
        this.reason = aReason;
    }

    public void setIsAvailable(boolean aIsAvailable) {
        this.available = aIsAvailable;
    }

    public void setLanguage(String aLang) {
        this.language = aLang;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/emailFwd-1.0";
    }
}

