/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.eai.v1_0;

import com.verisign.epp.codec.contact.EPPContactAddChange;
import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.util.TestThread;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPEAITst
extends TestCase {
    private static long numIterations = 1L;

    public EPPEAITst(String name) {
        super(name);
    }

    public void testContactCreate() {
        EPPCodecTst.printStart("testContactCreate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("D\u00f6rte S\u00f6rense", "Example Inc.", "loc", address);
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd("ABC-123451", "eai-contact", name, "D\u00f6rteS\u00f6rensen@example.com", new EPPAuthInfo(""));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactCreate");
    }

    public void testContactUpdate() {
        EPPContactUpdateCmd theCommand = null;
        EPPEncodeDecodeStats commandStats = null;
        EPPCodecTst.printStart("testContactUpdate");
        EPPContactAddChange changeItems = new EPPContactAddChange();
        changeItems.setEmail("D\u00f6rteS\u00f6rensen2@example.com");
        theCommand = new EPPContactUpdateCmd("ABC-123452", "eai-contact", null, null, changeItems);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactUpdate");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPEAITst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.contact.EPPContactMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPContactMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPEAITst Thread " + i, EPPEAITst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPEAITst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

