/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainAddRemove
implements EPPCodecComponent {
    private static final short MODE_NONE = 0;
    public static final short MODE_ADD = 1;
    public static final short MODE_REMOVE = 2;
    static final String ELM_ADD = "add";
    static final String ELM_REMOVE = "rem";
    static final String ELM_CHANGE = "chg";
    static final short MODE_CHANGE = 3;
    private static final String ELM_SERVER = "ns";
    private static final String ELM_HOST_OBJ = "hostObj";
    private static final String ELM_HOST_ATTR = "domain:hostAttr";
    private static final String ELM_CONTACT = "contact";
    private static final String ELM_STATUS = "status";
    private static final String ELM_REGISTRANT = "registrant";
    private static Logger cat = LoggerFactory.getLogger(EPPDomainAddRemove.class);
    private short mode = 0;
    private Vector<?> servers = null;
    private Vector<EPPHostAttr> attrServers = null;
    private Vector<EPPDomainContact> contacts = null;
    private Vector<EPPDomainStatus> statuses = null;
    private EPPAuthInfo authInfo = null;
    private String registrant = null;

    public EPPDomainAddRemove() {
        this.servers = null;
        this.servers = null;
        this.contacts = null;
        this.statuses = null;
        this.registrant = null;
        this.authInfo = null;
    }

    public EPPDomainAddRemove(Vector<?> aServers, Vector<EPPDomainContact> aContacts, Vector<EPPDomainStatus> aStatuses) {
        this.servers = aServers;
        this.contacts = aContacts;
        this.statuses = aStatuses;
    }

    public EPPDomainAddRemove(String aRegistrant, EPPAuthInfo aAuthInfo) {
        this.registrant = aRegistrant;
        this.setAuthInfo(aAuthInfo);
    }

    public boolean hasServers() {
        return this.servers != null;
    }

    public void addServer(String aServer) {
        if (this.servers == null) {
            this.servers = new Vector();
        }
        this.servers.add(aServer);
    }

    public void addServer(EPPHostAttr aServer) {
        if (this.servers == null) {
            this.servers = new Vector();
        }
        this.servers.add(aServer);
    }

    public Vector<?> getServers() {
        return this.servers;
    }

    public void setServers(Vector<?> aServers) {
        this.servers = aServers;
    }

    public boolean hasContacts() {
        return this.contacts != null;
    }

    public void addContact(EPPDomainContact aContact) {
        if (this.contacts == null) {
            this.contacts = new Vector();
        }
        this.contacts.add(aContact);
    }

    public Vector<EPPDomainContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(Vector<EPPDomainContact> aContacts) {
        this.contacts = aContacts;
    }

    public boolean hasStatuses() {
        return this.statuses != null;
    }

    public void addStatus(EPPDomainStatus aStatus) {
        if (this.statuses == null) {
            this.statuses = new Vector();
        }
        this.statuses.add(aStatus);
    }

    public Vector<EPPDomainStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Vector<EPPDomainStatus> aStatuses) {
        this.statuses = aStatuses;
    }

    public boolean contactsSupported() {
        return EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0");
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root;
        if (this.mode == 3) {
            Element root2 = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", "domain:chg");
            if (this.hasRegistrant()) {
                EPPUtil.encodeString(aDocument, root2, this.registrant, "urn:ietf:params:xml:ns:domain-1.0", "domain:registrant");
            }
            if (this.hasAuthInfo()) {
                EPPUtil.encodeComp(aDocument, root2, this.authInfo);
            }
            return root2;
        }
        if (this.mode == 1) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", "domain:add");
        } else if (this.mode == 2) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", "domain:rem");
        } else {
            throw new EPPEncodeException("Invalid EPPDomainAddRemove mode of " + this.mode);
        }
        if (this.hasServers() && this.servers.size() > 0) {
            Element theServersElm = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", "domain:ns");
            root.appendChild(theServersElm);
            Object theNS = this.servers.get(0);
            if (theNS instanceof String) {
                EPPUtil.encodeVector(aDocument, theServersElm, this.servers, "urn:ietf:params:xml:ns:domain-1.0", "domain:hostObj");
            } else if (theNS instanceof EPPHostAttr) {
                EPPUtil.encodeCompVector(aDocument, theServersElm, this.servers);
            } else {
                throw new EPPEncodeException("EPPDomainAddRemove.encode: Invalid NS server class " + theNS.getClass().getName());
            }
        }
        if (this.hasContacts()) {
            if (this.contactsSupported()) {
                EPPUtil.encodeCompVector(aDocument, root, this.contacts);
            } else {
                throw new EPPEncodeException("Contacts specified when the Contact Mapping is not supported");
            }
        }
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_ADD))) {
            this.mode = 1;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_REMOVE))) {
            this.mode = (short)2;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_CHANGE))) {
            this.mode = (short)3;
        } else {
            throw new EPPDecodeException("Invalid EPPDomainAddRemove mode of " + aElement.getLocalName());
        }
        if (this.mode == 3) {
            this.registrant = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_REGISTRANT);
            this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo", EPPAuthInfo.class);
        } else {
            Element theServerElm;
            Element theServersElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_SERVER);
            if (theServersElm != null && (theServerElm = EPPUtil.getFirstElementChild(theServersElm)) != null) {
                if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_OBJ))) {
                    this.servers = EPPUtil.decodeVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_OBJ);
                } else if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_ATTR))) {
                    this.servers = EPPUtil.decodeCompVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_ATTR, EPPHostAttr.class);
                } else {
                    throw new EPPDecodeException("EPPDomainAddRemove.doDecode: Invalid host child element " + theServersElm.getLocalName());
                }
                if (this.servers.size() == 0) {
                    this.servers = null;
                }
            }
            this.contacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CONTACT, EPPDomainContact.class);
            if (this.contacts.size() == 0) {
                this.contacts = null;
            }
            this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_STATUS, EPPDomainStatus.class);
            if (this.statuses.size() == 0) {
                this.statuses = null;
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainAddRemove)) {
            cat.error("EPPDomainAddRemove.equals(): " + aObject.getClass().getName() + " not EPPDomainAddRemove instance");
            return false;
        }
        EPPDomainAddRemove theComp = (EPPDomainAddRemove)aObject;
        if (this.mode != theComp.mode) {
            cat.error("EPPDomainAddRemove.equals(): mode not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.servers, theComp.servers)) {
            cat.error("EPPDomainAddRemove.equals(): servers not equal");
            return false;
        }
        if (this.contactsSupported() && !EqualityUtil.equals(this.contacts, theComp.contacts)) {
            cat.error("EPPDomainAddRemove.equals(): contacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.statuses, theComp.statuses)) {
            cat.error("EPPDomainAddRemove.equals(): statuses not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.registrant, theComp.registrant)) {
            cat.error("EPPDomainAddRemove.equals(): registrant not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfo, theComp.authInfo)) {
            cat.error("EPPDomainAddRemove.equals(): authInfo not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainAddRemove clone = null;
        clone = (EPPDomainAddRemove)super.clone();
        if (this.hasServers()) {
            clone.servers = (Vector)this.servers.clone();
        }
        if (this.hasContacts()) {
            clone.contacts = (Vector)this.contacts.clone();
            for (int i = 0; i < this.contacts.size(); ++i) {
                clone.contacts.setElementAt((EPPDomainContact)this.contacts.elementAt(i).clone(), i);
            }
        }
        if (this.hasStatuses()) {
            clone.statuses = (Vector)this.statuses.clone();
        }
        if (this.hasRegistrant()) {
            clone.registrant = this.registrant;
        }
        if (this.hasAuthInfo()) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasAuthInfo() {
        return this.authInfo != null;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        if (aAuthInfo != null) {
            this.authInfo = aAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        } else {
            this.authInfo = null;
        }
    }

    public boolean hasRegistrant() {
        return this.registrant != null;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setRegistrant(String aRegistrant) {
        this.registrant = aRegistrant;
    }

    public boolean isEmpty() {
        return !this.hasServers() && !this.hasContacts() && !this.hasStatuses() && !this.hasRegistrant() && !this.hasAuthInfo();
    }

    short getMode() {
        return this.mode;
    }

    void setMode(short aMode) {
        this.mode = aMode;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }
}

