/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactAddChange;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUpdateCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactUpdateCmd
extends EPPUpdateCmd {
    static final String ELM_NAME = "contact:update";
    private static final String ELM_CONTACT_ID = "contact:id";
    private EPPContactAddChange add = null;
    private EPPContactAddChange remove = null;
    private EPPContactAddChange change = null;
    private String id = null;
    private static Logger cat = LoggerFactory.getLogger(EPPContactUpdateCmd.class);

    public EPPContactUpdateCmd() {
    }

    public EPPContactUpdateCmd(String aTransId, String aId) {
        super(aTransId);
        this.id = aId;
    }

    public EPPContactUpdateCmd(String aTransId, String aId, EPPContactAddChange aAdd, EPPContactAddChange aRemove, EPPContactAddChange aChange) {
        super(aTransId);
        this.id = aId;
        this.add = aAdd;
        if (this.add != null) {
            this.add.setMode((short)1);
        }
        this.remove = aRemove;
        if (this.remove != null) {
            this.remove.setMode((short)2);
        }
        this.change = aChange;
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.id == null) {
            throw new EPPEncodeException("required attribute id is not set");
        }
        if (this.add == null && this.remove == null && this.change == null) {
            throw new EPPEncodeException("at least one from [add, remove, change] needs to be set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        EPPUtil.encodeComp(aDocument, root, this.add);
        EPPUtil.encodeComp(aDocument, root, this.remove);
        EPPUtil.encodeComp(aDocument, root, this.change);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.add = (EPPContactAddChange)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", "contact:add", EPPContactAddChange.class);
        if (this.add != null) {
            this.add.setMode((short)1);
        }
        this.remove = (EPPContactAddChange)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", "contact:rem", EPPContactAddChange.class);
        if (this.remove != null) {
            this.remove.setMode((short)2);
        }
        this.change = (EPPContactAddChange)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", "contact:chg", EPPContactAddChange.class);
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }

    @Override
    public boolean equals(Object aObject) {
        cat.debug("equals(Object): enter");
        if (!(aObject instanceof EPPContactUpdateCmd)) {
            cat.error("equals(Object): aObject not EPPContactUpdateCmd");
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error("equals(Object): parent not equal");
            return false;
        }
        EPPContactUpdateCmd theComp = (EPPContactUpdateCmd)aObject;
        if (!(this.id != null ? this.id.equals(theComp.id) : theComp.id == null)) {
            cat.error("equals(Object): id not equal");
            return false;
        }
        if (!(this.add != null ? this.add.equals(theComp.add) : theComp.add == null)) {
            cat.error("equals(Object): add not equal");
            return false;
        }
        if (!(this.remove != null ? this.remove.equals(theComp.remove) : theComp.remove == null)) {
            cat.error("equals(Object): remove not equal");
            return false;
        }
        if (!(this.change != null ? this.change.equals(theComp.change) : theComp.change == null)) {
            cat.error("equals(Object): change not equal");
            return false;
        }
        cat.debug("equals(Object): exit, return true");
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactUpdateCmd clone = (EPPContactUpdateCmd)super.clone();
        if (clone.add != null) {
            clone.add = (EPPContactAddChange)this.add.clone();
        }
        if (clone.remove != null) {
            clone.remove = (EPPContactAddChange)this.remove.clone();
        }
        if (clone.change != null) {
            clone.change = (EPPContactAddChange)this.change.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public boolean hasAdd() {
        return this.add != null;
    }

    public EPPContactAddChange getAdd() {
        return this.add;
    }

    public void setAdd(EPPContactAddChange aAdd) {
        this.add = aAdd;
        if (this.add != null) {
            this.add.setMode((short)1);
        }
    }

    public boolean hasChange() {
        return this.change != null;
    }

    public EPPContactAddChange getChange() {
        return this.change;
    }

    public void setChange(EPPContactAddChange aChange) {
        this.change = aChange;
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }

    public boolean hasRemove() {
        return this.remove != null;
    }

    public EPPContactAddChange getRemove() {
        return this.remove;
    }

    public void setRemove(EPPContactAddChange aRemove) {
        this.remove = aRemove;
        if (this.remove != null) {
            this.remove.setMode((short)2);
        }
    }
}

