/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPContactCheckResult
implements EPPCodecComponent {
    static final String ELM_NAME = "contact:cd";
    static final String ELM_CONTACT_ID = "contact:id";
    private static final String ELM_CONTACT_REASON = "contact:reason";
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_LANG = "lang";
    private static final String VALUE_LANG = "en";
    private String language = "en";
    private String id = null;
    private boolean available;
    private String reason;

    public EPPContactCheckResult() {
        this.id = null;
        this.available = true;
    }

    public EPPContactCheckResult(String aId, boolean aIsAvailable) {
        this.id = aId;
        this.available = aIsAvailable;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setIsAvailable(boolean aIsAvailable) {
        this.available = aIsAvailable;
    }

    public void setLanguage(String aLang) {
        this.language = aLang;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setContactReason(String aReason) {
        this.reason = aReason;
    }

    public String getContactReason() {
        return this.reason;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.id == null) {
            throw new EPPEncodeException("name required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        root.appendChild(nameElm);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_AVAIL, this.available);
        Text textNode = aDocument.createTextNode(this.id);
        nameElm.appendChild(textNode);
        if (this.reason != null) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_REASON);
            root.appendChild(reasonElm);
            if (!this.language.equals(VALUE_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.available = EPPUtil.decodeBooleanAttr(currElm, ATTR_AVAIL);
        this.id = currElm.getFirstChild().getNodeValue();
        currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_REASON);
        if (currElm != null) {
            this.reason = currElm.getFirstChild().getNodeValue();
            String lang = currElm.getAttribute(ATTR_LANG);
            if (lang.length() > 0 && !lang.equals(VALUE_LANG)) {
                this.setLanguage(lang);
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactCheckResult)) {
            return false;
        }
        EPPContactCheckResult theComp = (EPPContactCheckResult)aObject;
        if (!(this.id != null ? this.id.equals(theComp.id) : theComp.id == null)) {
            return false;
        }
        return this.available == theComp.available;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactCheckResult clone = null;
        clone = (EPPContactCheckResult)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }
}

