/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.balance;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPCreditThreshold
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPCreditThreshold.class);
    public static final String FIXED = "FIXED";
    public static final String PERCENT = "PERCENT";
    static final String ELM_NAME = "balance:creditThreshold";
    static final String ELM_FIXED = "balance:fixed";
    static final String ELM_PERCENT = "balance:percent";
    static final String ATTR_NAME = "type";
    private String type = "FIXED";
    private BigDecimal value = null;

    public EPPCreditThreshold() {
    }

    public EPPCreditThreshold(String aType, BigDecimal aCreditThresholdValue) {
        this.type = aType;
        this.value = aCreditThresholdValue;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPCreditThreshold.doEncode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPCreditThreshold invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/balance-1.0", ELM_NAME);
        Element valueElm = this.type.equals(FIXED) ? aDocument.createElementNS("http://www.verisign.com/epp/balance-1.0", ELM_FIXED) : aDocument.createElementNS("http://www.verisign.com/epp/balance-1.0", ELM_PERCENT);
        Text descVal = aDocument.createTextNode(this.value.toString());
        valueElm.appendChild(descVal);
        root.appendChild(valueElm);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element valueElm = EPPUtil.getFirstElementChild(aElement);
        this.type = valueElm.getLocalName().equals(EPPUtil.getLocalName(ELM_FIXED)) ? FIXED : PERCENT;
        this.value = new BigDecimal(valueElm.getFirstChild().getNodeValue());
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPCreditThreshold)) {
            return false;
        }
        EPPCreditThreshold theComp = (EPPCreditThreshold)aObject;
        if (!this.type.equals(theComp.type)) {
            return false;
        }
        return this.value.equals(theComp.value);
    }

    void validateState() throws EPPCodecException {
        if (this.type == null) {
            throw new EPPCodecException("EPPCreditThreshold1 required attribute is not set");
        }
        if (this.value == null) {
            throw new EPPCodecException("EPPCreditThreshold2 required attribute is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPCreditThreshold clone = null;
        clone = (EPPCreditThreshold)super.clone();
        clone.type = this.type;
        clone.value = this.value != null ? new BigDecimal(this.value.toString()) : null;
        return clone;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        if (aType.equals(FIXED) || aType.equals(PERCENT)) {
            this.type = aType;
        }
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal aCreditThresholdValue) {
        this.value = aCreditThresholdValue;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/balance-1.0";
    }
}

