/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPSendReceiveLogger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EPPXMLErrorHandler
implements ErrorHandler {
    private static EPPSendReceiveLogger sendReceiveLogger = EPPEnv.getSendReceiveLogger();

    @Override
    public void error(SAXParseException aException) throws SAXException {
        throw new SAXException(this.getErrorString(aException));
    }

    @Override
    public void fatalError(SAXParseException aException) throws SAXException {
        throw new SAXException(this.getErrorString(aException));
    }

    @Override
    public void warning(SAXParseException aException) throws SAXException {
        throw new SAXException(this.getErrorString(aException));
    }

    private String getErrorString(SAXParseException aException) {
        StringBuffer theError = new StringBuffer();
        String systemId = aException.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            theError.append(systemId);
        }
        theError.append("Line: ");
        theError.append(aException.getLineNumber());
        theError.append(", Column: ");
        theError.append(aException.getColumnNumber());
        theError.append(", Message: ");
        theError.append(sendReceiveLogger.maskString(aException.getMessage()));
        return theError.toString();
    }
}

