/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.client;

import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.client.EPPProxyServer;
import com.verisign.epp.transport.client.EPPProxyServersLocator;
import com.verisign.epp.transport.client.EPPSSLClientSocket;
import com.verisign.epp.transport.client.EPPSSLImpl;
import com.verisign.epp.util.EPPEnv;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPSSLProxyClientSocket
extends EPPSSLClientSocket {
    private static Logger cat = LoggerFactory.getLogger(EPPSSLProxyClientSocket.class);
    private List proxyServers;
    private boolean proxyServersRandomize;
    private static EPPProxyServersLocator locator = null;

    public EPPSSLProxyClientSocket() throws EPPConException {
        cat.debug("EPPSSLProxyClientSocket(): start");
        try {
            if (locator == null) {
                String theProxyServerLocatorProp = EPPEnv.getProxyServerLocator();
                Class<?> locatorClass = Class.forName(theProxyServerLocatorProp);
                if (!EPPProxyServersLocator.class.isAssignableFrom(locatorClass)) {
                    throw new EPPConException(theProxyServerLocatorProp + " does not implement EPPProxyServersLocator");
                }
                locator = (EPPProxyServersLocator)locatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.proxyServers = locator.getProxyServers();
            this.proxyServersRandomize = EPPEnv.getProxyServersRandomize();
        }
        catch (Exception ex) {
            cat.error("Connection Failed Due to : " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("Connection Failed Due to : " + ex.getMessage());
        }
        if (this.proxyServers.size() == 0) {
            throw new EPPConException("No proxy servers defined by EPP.ProxyServers configuration property");
        }
        cat.debug("EPPSSLProxyClientSocket(): exit");
    }

    @Override
    public void initialize() throws EPPConException {
        SSLSocket theSSLSocket;
        cat.debug("initialize(): start");
        if (super.getSslContext() == null) {
            EPPSSLImpl.initialize();
            super.setSslContext(EPPSSLImpl.getEPPSSLContext());
        }
        SSLSocketFactory theSSLSocketFactory = super.getSslContext().getSSLSocketFactory();
        boolean theConnectedToProxy = false;
        ArrayList theProxyList = new ArrayList(this.proxyServers);
        Random theRandom = new Random();
        Socket theSocket = null;
        EPPProxyServer theCurrProxy = null;
        cat.debug("initialize(): proxy server list size = " + theProxyList.size());
        block8: while (!theConnectedToProxy && theProxyList.size() != 0) {
            int theCurrProxyIndex = this.proxyServersRandomize ? theRandom.nextInt(theProxyList.size()) : 0;
            cat.debug("initialize(): proxy server selected index " + theCurrProxyIndex + " of " + theProxyList.size() + " servers");
            theCurrProxy = (EPPProxyServer)theProxyList.get(theCurrProxyIndex);
            theProxyList.remove(theCurrProxyIndex);
            cat.debug("initialize(): proxy server = " + theCurrProxy);
            InetSocketAddress theSocketAddress = new InetSocketAddress(theCurrProxy.getServerName(), theCurrProxy.getServerPort());
            theSocket = new Socket();
            try {
                if (super.getClientHostName() != null) {
                    cat.debug("initialize(): Binding to client address = " + super.getClientHostName());
                    InetSocketAddress theClientSocketAddress = new InetSocketAddress(super.getClientHostName(), 0);
                    theSocket.bind(theClientSocketAddress);
                }
                cat.debug("initialize(): Attempting to connect proxy server = " + theCurrProxy);
                theSocket.connect(theSocketAddress, super.getConTimeout());
                theSocket.setSoTimeout(super.getConTimeout());
                OutputStream theStream = theSocket.getOutputStream();
                Object theLine = "CONNECT " + super.getHostName() + ":" + super.getPortNumber() + " HTTP/1.1\r\n";
                cat.debug("Proxy Server Send [" + (String)theLine + "]");
                theStream.write(((String)theLine).getBytes());
                theLine = "Host: " + super.getHostName() + ":" + super.getPortNumber() + "\r\n";
                cat.debug("Proxy Server Send [" + (String)theLine + "]");
                theStream.write(((String)theLine).getBytes());
                theLine = "\r\n";
                cat.debug("Proxy Server Send [" + (String)theLine + "]");
                theStream.write(((String)theLine).getBytes());
                theStream.flush();
                BufferedReader theInputStream = new BufferedReader(new InputStreamReader(theSocket.getInputStream()));
                int theLineNum = 1;
                do {
                    theLine = theInputStream.readLine();
                    cat.debug("Proxy output line [" + (String)theLine + "]");
                    if (theLineNum == 1) {
                        if (theLine != null && ((String)theLine).indexOf("Connection Established") != -1) {
                            theConnectedToProxy = true;
                            cat.info("Proxy Server " + theCurrProxy + " TCP connection established");
                        } else {
                            cat.info("Proxy Server " + theCurrProxy + " TCP connection failed: " + (String)theLine);
                            theSocket.close();
                            continue block8;
                        }
                    }
                    ++theLineNum;
                    if (theLine == null) continue block8;
                } while (((String)theLine).length() != 0);
            }
            catch (IOException ex) {
                cat.info("Proxy Server " + theCurrProxy + " TCP connection failed: " + ex);
            }
        }
        if (!theConnectedToProxy) {
            cat.error("All Proxy Server connections failed");
            throw new EPPConException("All Proxy Server connections failed");
        }
        try {
            theSSLSocket = (SSLSocket)theSSLSocketFactory.createSocket(theSocket, super.getHostName(), super.getPortNumber(), true);
        }
        catch (IOException ex) {
            cat.error("Proxy Server " + theCurrProxy + " failure creating SSLSocket connection to " + super.getHostName() + ":" + super.getPortNumber() + ": " + ex);
            throw new EPPConException("Proxy Server " + theCurrProxy + " failure creating SSLSocket connection to " + super.getHostName() + ":" + super.getPortNumber() + ": " + ex);
        }
        if (cat.isDebugEnabled()) {
            cat.debug("EPPSSLClientSocket.initialize(): Supported Protocols = [" + this.getSSLPropertyListString(theSSLSocket.getSupportedProtocols()) + "], Supported Cipher Suites = [" + this.getSSLPropertyListString(theSSLSocket.getSupportedCipherSuites()) + "]");
        }
        if (super.getSslContext().hasSSLEnabledProtocols()) {
            cat.debug("EPPSSLClientSocket.initialize(): Enabled Protocols = [" + this.getSSLPropertyListString(super.getSslContext().getSSLEnabledProtocols()) + "]");
            theSSLSocket.setEnabledProtocols(super.getSslContext().getSSLEnabledProtocols());
        } else {
            cat.debug("EPPSSLClientSocket.initialize(): Enabled Protocols NOT specified, using providers default");
        }
        if (super.getSslContext().hasSSLEnabledCipherSuites()) {
            cat.debug("EPPSSLClientSocket.initialize(): Enabled Cipher Suites = [" + this.getSSLPropertyListString(super.getSslContext().getSSLEnabledCipherSuites()) + "]");
            theSSLSocket.setEnabledCipherSuites(super.getSslContext().getSSLEnabledCipherSuites());
        } else {
            cat.debug("EPPSSLClientSocket.initialize(): Enabled Cipher Suites NOT specified, using providers default");
        }
        cat.debug("EPPSSLClientSocket.initialize(): SSL startHandshake");
        try {
            theSSLSocket.startHandshake();
        }
        catch (IOException ex) {
            cat.error("Proxy Server " + theCurrProxy + " failed with SSL handshake to " + super.getHostName() + ":" + super.getPortNumber(), (Throwable)ex);
            throw new EPPConException("Proxy Server " + theCurrProxy + " failed with SSL handshake to " + super.getHostName() + ":" + super.getPortNumber() + ": " + ex.getMessage());
        }
        try {
            super.setInputStream(theSSLSocket.getInputStream());
            super.setOutputStream(theSSLSocket.getOutputStream());
            super.setSocket(theSSLSocket);
            super.setConnected(true);
        }
        catch (IOException ex) {
            cat.error("Failed getting streams from SSL socket: " + ex.getMessage());
            throw new EPPConException("Failed getting streams from SSL socket: " + ex.getMessage());
        }
        cat.debug("initialize(): exit");
    }

    public static EPPProxyServersLocator getLocator() {
        return locator;
    }

    public static void setLocator(EPPProxyServersLocator aLocator) {
        locator = aLocator;
    }
}

