/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.eai.v1_0;

import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.ContactHandler;
import com.verisign.epp.serverstub.SessionData;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EAIContactHandler
extends ContactHandler {
    private static final String svrTransId = "54322-XYZ";
    private static Logger cat = LoggerFactory.getLogger(EAIContactHandler.class);

    @Override
    public EPPEventResponse doContactCreate(EPPEvent aEvent, Object aData) {
        SessionData sessionData = (SessionData)aData;
        EPPContactCreateCmd theCommand = (EPPContactCreateCmd)aEvent.getMessage();
        if (theCommand.getId().startsWith("EAI")) {
            if (theCommand.getId().equalsIgnoreCase("EAI-notsupported") || !this.supportsNamespace("urn:ietf:params:xml:schema:epp:eai-1.0", sessionData.getLoginCmd().getExtensionServices())) {
                if (theCommand.hasEmail() && !Charset.forName("US-ASCII").newEncoder().canEncode(theCommand.getEmail())) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                    EPPResponse theResponse = new EPPResponse(transId);
                    EPPResult theResult = new EPPResult(2308);
                    theResult.addExtValueReason("EAI not supported with EAI value");
                    theResponse.setResult(theResult);
                    return new EPPEventResponse(theResponse);
                }
                return super.doContactCreate(aEvent, aData);
            }
            return super.doContactCreate(aEvent, aData);
        }
        return super.doContactCreate(aEvent, aData);
    }

    @Override
    public EPPEventResponse doContactUpdate(EPPEvent aEvent, Object aData) {
        SessionData sessionData = (SessionData)aData;
        EPPContactUpdateCmd theCommand = (EPPContactUpdateCmd)aEvent.getMessage();
        if (theCommand.getId().startsWith("EAI")) {
            if (theCommand.getId().equalsIgnoreCase("EAI-notsupported") || !this.supportsNamespace("urn:ietf:params:xml:schema:epp:eai-1.0", sessionData.getLoginCmd().getExtensionServices())) {
                if (theCommand.hasChange() && theCommand.getChange().hasEmail() && !Charset.forName("US-ASCII").newEncoder().canEncode(theCommand.getChange().getEmail())) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                    EPPResponse theResponse = new EPPResponse(transId);
                    EPPResult theResult = new EPPResult(2308);
                    theResult.addExtValueReason("EAI not supported with EAI value");
                    theResponse.setResult(theResult);
                    return new EPPEventResponse(theResponse);
                }
                return super.doContactUpdate(aEvent, aData);
            }
            return super.doContactUpdate(aEvent, aData);
        }
        return super.doContactUpdate(aEvent, aData);
    }

    @Override
    public EPPEventResponse doContactInfo(EPPEvent aEvent, Object aData) {
        SessionData sessionData = (SessionData)aData;
        EPPContactInfoCmd theCommand = (EPPContactInfoCmd)aEvent.getMessage();
        if (theCommand.getId().startsWith("EAI")) {
            if (theCommand.getId().equalsIgnoreCase("EAI-notsupported") || !this.supportsNamespace("urn:ietf:params:xml:schema:epp:eai-1.0", sessionData.getLoginCmd().getExtensionServices())) {
                EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                EPPResponse theResponse = new EPPResponse(transId);
                EPPResult theResult = new EPPResult(2308);
                theResult.addExtValueReason("EAI not supported with EAI value");
                theResponse.setResult(theResult);
                return new EPPEventResponse(theResponse);
            }
            EPPContactInfoResp theResponse = super.getDefaultInfoResponseWithAllElements(theCommand);
            theResponse.setEmail("D\u00f6rteS\u00f6rensen2@example.com");
            return new EPPEventResponse(theResponse);
        }
        return super.doContactInfo(aEvent, aData);
    }

    private boolean supportsNamespace(String aNamespace, List<EPPService> aServices) {
        cat.debug("supportsNamespace(String, List); Looking for namespace " + aNamespace + " support");
        if (aServices != null) {
            for (EPPService theService : aServices) {
                if (!theService.getNamespaceURI().equals(aNamespace)) continue;
                cat.debug("supportsNamespace(String, List); namespace " + aNamespace + " supported");
                return true;
            }
        }
        cat.debug("supportsNamespace(String, List); namespace " + aNamespace + " not supported");
        return false;
    }
}

