/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtUpdate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtCreate;
import com.verisign.epp.framework.EPPDomainHandler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.SecDNSV10SubDomainHandler;
import com.verisign.epp.serverstub.SecDNSV11SubDomainHandler;
import com.verisign.epp.serverstub.SessionData;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecDNSDomainHandler
extends EPPDomainHandler {
    private static final String svrTransId = "54322-XYZ";
    private static final String roid = "NS1EXAMPLE1-VRSN";
    private static Logger cat = LoggerFactory.getLogger(SecDNSDomainHandler.class);
    SecDNSV10SubDomainHandler v10SubHandler = new SecDNSV10SubDomainHandler();
    SecDNSV11SubDomainHandler v11SubHandler = new SecDNSV11SubDomainHandler();

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2500);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
    }

    @Override
    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    @Override
    protected EPPEventResponse doDomainCheck(EPPEvent aEvent, Object aData) {
        EPPDomainCheckCmd theMessage = (EPPDomainCheckCmd)aEvent.getMessage();
        Vector vNames = theMessage.getNames();
        Enumeration eNames = vNames.elements();
        Vector<EPPDomainCheckResult> vResults = new Vector<EPPDomainCheckResult>();
        boolean known = true;
        while (eNames.hasMoreElements()) {
            String domainName = (String)eNames.nextElement();
            known = !known;
            vResults.addElement(new EPPDomainCheckResult(domainName, known));
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainCheckResp theResponse = new EPPDomainCheckResp(transId, vResults);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainRenew(EPPEvent aEvent, Object aData) {
        EPPDomainRenewCmd theMessage = (EPPDomainRenewCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainRenewResp theResponse = new EPPDomainRenewResp(transId, theMessage.getName(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        EPPDomainDeleteCmd theMessage = (EPPDomainDeleteCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(transId, theMessage.getName(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPResponse theResponse;
        EPPDomainCreateCmd theMessage = (EPPDomainCreateCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (theMessage.hasExtension(com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtCreate.class) && theMessage.hasExtension(EPPSecDNSExtCreate.class)) {
            cat.error("SecDNSDomainHandler.doDomainCreate: both v10 and v11 of EPPSecDNSExtCreate passed.");
            EPPResult theResult = new EPPResult(2306);
            theResult.addExtValueReason("Both v10 and v11 of secDNS extension passed");
            theResponse = new EPPResponse(null, theResult);
        } else if (theMessage.hasExtension(com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtCreate.class)) {
            theResponse = this.v10SubHandler.doDomainCreate(theMessage, aData);
        } else if (theMessage.hasExtension(EPPSecDNSExtCreate.class)) {
            theResponse = this.v11SubHandler.doDomainCreate(theMessage, aData);
        } else {
            cat.info("SecDNSDomainHandler.doDomainCreate: no EPPSecDNSExtCreate extension");
            theResponse = new EPPDomainCreateResp(theTransId, theMessage.getName(), new Date());
        }
        theResponse.setTransId(theTransId);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        EPPDomainTransferCmd theMessage = (EPPDomainTransferCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (theMessage.getOp().equals("request")) {
            EPPDomainTransferResp thePollMsg = new EPPDomainTransferResp();
            thePollMsg.setName("example");
            thePollMsg.setTransferStatus("pending");
            thePollMsg.setRequestClient("ClientX");
            thePollMsg.setRequestDate(new Date());
            thePollMsg.setActionClient("ClientY");
            thePollMsg.setActionDate(new Date());
            thePollMsg.setExpirationDate(new Date());
            thePollMsg.setResult(1000);
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error("doDomainTransfer: Error putting message [" + thePollMsg + "]");
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(theResponse);
            }
        }
        EPPDomainTransferResp theResponse = new EPPDomainTransferResp(transId, theMessage.getName());
        theResponse.setTransferStatus("pending");
        theResponse.setRequestClient("ClientX");
        theResponse.setRequestDate(new Date());
        theResponse.setActionClient("ClientY");
        theResponse.setActionDate(new Date());
        theResponse.setExpirationDate(new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPResponse theResponse;
        EPPDomainUpdateCmd theMessage = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (theMessage.hasExtension(EPPSecDNSExtUpdate.class) && theMessage.hasExtension(com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate.class)) {
            cat.error("SecDNSDomainHandler.doDomainUpdate: both v10 and v11 of EPPSecDNSExtUpdate passed.");
            EPPResult theResult = new EPPResult(2306);
            theResult.addExtValueReason("Both v10 and v11 of secDNS extension passed");
            theResponse = new EPPResponse(null, theResult);
        } else if (theMessage.hasExtension(EPPSecDNSExtUpdate.class)) {
            theResponse = this.v10SubHandler.doDomainUpdate(theMessage, aData);
        } else if (theMessage.hasExtension(com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate.class)) {
            theResponse = this.v11SubHandler.doDomainUpdate(theMessage, aData);
        } else {
            cat.info("SecDNSDomainHandler.doDomainUpdate: no EPPSecDNSExtUpdate extension");
            theResponse = new EPPResponse();
        }
        theResponse.setTransId(theTransId);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPDomainInfoCmd theMessage = (EPPDomainInfoCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theMessage.getTransId(), svrTransId);
        Vector<EPPDomainStatus> theStatuses = new Vector<EPPDomainStatus>();
        theStatuses.addElement(new EPPDomainStatus("ok"));
        theStatuses.addElement(new EPPDomainStatus("clientHold"));
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(null, roid, theMessage.getName(), "ClientX", theStatuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        Vector<String> theNses = new Vector<String>();
        theNses.addElement("ns1." + theMessage.getName());
        theNses.addElement("ns2." + theMessage.getName());
        theResponse.setNses(theNses);
        Vector<String> theHosts = new Vector<String>();
        theHosts.addElement("ns1." + theMessage.getName());
        theHosts.addElement("ns2." + theMessage.getName());
        theResponse.setHosts(theHosts);
        Vector<EPPDomainContact> theContacts = new Vector<EPPDomainContact>();
        theContacts.addElement(new EPPDomainContact("sh8013", "admin"));
        theContacts.addElement(new EPPDomainContact("sh8013", "billing"));
        theContacts.addElement(new EPPDomainContact("sh8013", "tech"));
        theResponse.setContacts(theContacts);
        GregorianCalendar theCal = new GregorianCalendar();
        theCal.setTime(new Date());
        theCal.add(1, 1);
        theResponse.setExpirationDate(theCal.getTime());
        theResponse.setRegistrant("jd1234");
        theResponse.setResult(1000);
        theResponse.setTransId(theTransId);
        SessionData theSessionData = (SessionData)aData;
        boolean hasV10ExtService = theSessionData.getLoginCmd().hasExtensionService("urn:ietf:params:xml:ns:secDNS-1.0");
        boolean hasV11ExtService = theSessionData.getLoginCmd().hasExtensionService("urn:ietf:params:xml:ns:secDNS-1.1");
        if (hasV11ExtService) {
            theResponse = this.v11SubHandler.doDomainInfo(theMessage, theResponse, aData);
        } else if (hasV10ExtService) {
            theResponse = this.v10SubHandler.doDomainInfo(theMessage, theResponse, aData);
        } else {
            cat.info("SecDNSDomainHandler.doDomainInfo: no secDNS extension URI specified in login");
        }
        return new EPPEventResponse(theResponse);
    }
}

