/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.registry.policy.EPPRegistryZoneInterface;
import com.verisign.epp.framework.EPPRegistryPolicyAdapter;
import com.verisign.epp.util.EPPEnv;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryPolicyCompositeAdapter {
    private static Logger cat = LoggerFactory.getLogger(RegistryPolicyCompositeAdapter.class);
    private static List<EPPRegistryPolicyAdapter> adapters = new ArrayList<EPPRegistryPolicyAdapter>();

    public List<EPPRegistryZoneInterface> eppExtToZoneExt(List<EPPCodecComponent> aEppExtensions) {
        cat.debug("eppExtToZoneExt: enter");
        ArrayList<EPPRegistryZoneInterface> theZoneExts = new ArrayList<EPPRegistryZoneInterface>();
        for (EPPRegistryPolicyAdapter theAdapter : adapters) {
            EPPRegistryZoneInterface theZoneExt = theAdapter.eppExtToZoneExt(aEppExtensions);
            if (theZoneExt == null) continue;
            cat.debug("eppExtToZoneExt: adding zone extension " + theZoneExt.getClass().getName());
            theZoneExts.add(theZoneExt);
        }
        cat.debug("eppExtToZoneExt: exit");
        return theZoneExts;
    }

    public List<EPPCodecComponent> zoneExtToEppExt(List<EPPRegistryZoneInterface> aZoneExtensions) {
        cat.debug("zoneExtToEppExt: enter");
        ArrayList<EPPCodecComponent> TheEppExts = new ArrayList<EPPCodecComponent>();
        for (EPPRegistryPolicyAdapter theAdapter : adapters) {
            EPPCodecComponent theEppExt = theAdapter.zoneExtToEppExt(aZoneExtensions);
            if (theEppExt == null) continue;
            cat.debug("zoneExtToEppExt: adding EPP extension " + theEppExt.getClass().getName());
            TheEppExts.add(theEppExt);
        }
        cat.debug("zoneExtToEppExt: exit");
        return TheEppExts;
    }

    public List<EPPCodecComponent> getSystemExts() {
        cat.debug("getSystemExts: enter");
        ArrayList<EPPCodecComponent> TheEppExts = new ArrayList<EPPCodecComponent>();
        for (EPPRegistryPolicyAdapter theAdapter : adapters) {
            EPPCodecComponent theEppExt = theAdapter.getSystemExt();
            if (theEppExt == null) continue;
            cat.debug("getSystemExts: adding EPP extension " + theEppExt.getClass().getName());
            TheEppExts.add(theEppExt);
        }
        cat.debug("getSystemExts: exit");
        return TheEppExts;
    }

    static {
        List<String> theAdapters = EPPEnv.getRegistryPolicyAdapters();
        if (theAdapters != null) {
            for (String theAdapter : theAdapters) {
                try {
                    adapters.add((EPPRegistryPolicyAdapter)Class.forName(theAdapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception ex) {
                    cat.error("Exception loading EPPRegistryPolicyAdapter class \"" + theAdapter + "\": " + ex);
                }
            }
        }
    }
}

