/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckResult;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdContact;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdDeleteCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdStatus;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPEmailFwdHandler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.serverstub.SessionData;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class EmailFwdHandler
extends EPPEmailFwdHandler {
    private static final String svrTransId = "54322-XYZ";
    private static final String roid = "NS1EXAMPLE1-VRSN";

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2500);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
    }

    @Override
    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    @Override
    protected EPPEventResponse doEmailFwdCheck(EPPEvent aEvent, Object aData) {
        EPPEmailFwdCheckCmd theMessage = (EPPEmailFwdCheckCmd)aEvent.getMessage();
        Vector vNames = theMessage.getNames();
        Enumeration eNames = vNames.elements();
        Vector<EPPEmailFwdCheckResult> vResults = new Vector<EPPEmailFwdCheckResult>();
        boolean available = true;
        while (eNames.hasMoreElements()) {
            String emailFwdName = (String)eNames.nextElement();
            EPPEmailFwdCheckResult theResult = new EPPEmailFwdCheckResult(emailFwdName, available);
            if (!available) {
                theResult.setEmailFwdReason("In use");
            }
            vResults.addElement(theResult);
            available = !available;
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPEmailFwdCheckResp theResponse = new EPPEmailFwdCheckResp(transId, vResults);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doEmailFwdRenew(EPPEvent aEvent, Object aData) {
        EPPEmailFwdRenewCmd theMessage = (EPPEmailFwdRenewCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPEmailFwdRenewResp theResponse = new EPPEmailFwdRenewResp(transId, theMessage.getName(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doEmailFwdDelete(EPPEvent aEvent, Object aData) {
        EPPEmailFwdDeleteCmd theMessage = (EPPEmailFwdDeleteCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPEmailFwdCreateResp theResponse = new EPPEmailFwdCreateResp(transId, theMessage.getName(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doEmailFwdCreate(EPPEvent aEvent, Object aData) {
        EPPEmailFwdCreateCmd theMessage = (EPPEmailFwdCreateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPEmailFwdCreateResp theResponse = new EPPEmailFwdCreateResp(transId, theMessage.getName(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doEmailFwdTransfer(EPPEvent aEvent, Object aData) {
        EPPEmailFwdTransferCmd theMessage = (EPPEmailFwdTransferCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPEmailFwdTransferResp theResponse = new EPPEmailFwdTransferResp(transId, theMessage.getName());
        theResponse.setTransferStatus("pending");
        theResponse.setRequestClient("ClientX");
        theResponse.setRequestDate(new Date());
        theResponse.setActionClient("ClientY");
        theResponse.setActionDate(new Date());
        theResponse.setExpirationDate(new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doEmailFwdUpdate(EPPEvent aEvent, Object aData) {
        EPPEmailFwdUpdateCmd theMessage = (EPPEmailFwdUpdateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doEmailFwdInfo(EPPEvent aEvent, Object aData) {
        EPPEmailFwdInfoCmd theMessage = (EPPEmailFwdInfoCmd)aEvent.getMessage();
        Vector<EPPEmailFwdStatus> statuses = new Vector<EPPEmailFwdStatus>();
        statuses.addElement(new EPPEmailFwdStatus("ok"));
        statuses.addElement(new EPPEmailFwdStatus("clientHold"));
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPEmailFwdInfoResp theResponse = new EPPEmailFwdInfoResp(transId, roid, theMessage.getName(), "jdoe@example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        Vector<EPPEmailFwdContact> theContacts = new Vector<EPPEmailFwdContact>();
        theContacts.addElement(new EPPEmailFwdContact("sh8013", "admin"));
        theContacts.addElement(new EPPEmailFwdContact("sh8013", "billing"));
        theContacts.addElement(new EPPEmailFwdContact("sh8013", "tech"));
        theResponse.setContacts(theContacts);
        GregorianCalendar theCal = new GregorianCalendar();
        theCal.setTime(new Date());
        theCal.add(1, 1);
        theResponse.setExpirationDate(theCal.getTime());
        theResponse.setRegistrant("jd1234");
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }
}

