/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.allocationtoken.EPPAllocationToken;
import com.verisign.epp.codec.allocationtoken.EPPAllocationTokenInfo;
import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.serverstub.DomainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationTokenDomainHandler
extends DomainHandler {
    private static Logger cat = LoggerFactory.getLogger(AllocationTokenDomainHandler.class);

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        super.preHandleEvent(aEvent, aData);
    }

    @Override
    protected EPPEventResponse doDomainCheck(EPPEvent aEvent, Object aData) {
        EPPDomainCheckCmd theCommand = (EPPDomainCheckCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPAllocationToken.class)) {
            EPPAllocationToken theExt = (EPPAllocationToken)theCommand.getExtension(EPPAllocationToken.class);
            cat.info("doDomainCheck: allocation token = " + theExt.getToken());
            System.out.println("doDomainCheck: allocation token = " + theExt.getToken());
        } else {
            cat.info("doDomainCheck: allocation token = null");
            System.out.println("doDomainCheck: allocation token = null");
        }
        EPPEventResponse theEventResponse = super.doDomainCheck(aEvent, aData);
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        if (theCommand.hasExtension(EPPAllocationTokenInfo.class)) {
            EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
            theResponse.addExtension(new EPPAllocationToken("abc123"));
            cat.info("doDomainInfo: allocation token added to response");
            System.out.println("doDomainInfo: allocation token added to response");
        } else {
            cat.info("doDomainInfo: allocation token info extension not passed");
            System.out.println("doDomainInfo: allocation token info extension not passed");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPAllocationToken.class)) {
            EPPAllocationToken theExt = (EPPAllocationToken)theCommand.getExtension(EPPAllocationToken.class);
            cat.info("doDomainCreate: allocation token = " + theExt.getToken());
            System.out.println("doDomainCreate: allocation token = " + theExt.getToken());
        } else {
            cat.info("doDomainCreate: allocation token = null");
            System.out.println("doDomainCreate: allocation token = null");
        }
        EPPEventResponse theEventResponse = super.doDomainCreate(aEvent, aData);
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPDomainUpdateCmd theCommand = (EPPDomainUpdateCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPAllocationToken.class)) {
            EPPAllocationToken theExt = (EPPAllocationToken)theCommand.getExtension(EPPAllocationToken.class);
            cat.info("doDomainUpdate: allocation token = " + theExt.getToken());
            System.out.println("doDomainUpdate: allocation token = " + theExt.getToken());
        } else {
            cat.info("doDomainUpdate: allocation token = null");
            System.out.println("doDomainUpdate: allocation token = null");
        }
        EPPEventResponse theEventResponse = super.doDomainUpdate(aEvent, aData);
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        EPPDomainTransferCmd theCommand = (EPPDomainTransferCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPAllocationToken.class)) {
            EPPAllocationToken theExt = (EPPAllocationToken)theCommand.getExtension(EPPAllocationToken.class);
            cat.info("doDomainTransfer: allocation token = " + theExt.getToken());
            System.out.println("doDomainTransfer: allocation token = " + theExt.getToken());
        } else {
            cat.info("doDomainTransfer: allocation token = null");
            System.out.println("doDomainTransfer: allocation token = null");
        }
        EPPEventResponse theEventResponse = super.doDomainTransfer(aEvent, aData);
        return theEventResponse;
    }
}

