/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool.parser;

import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPSchemaCachingParser;
import org.apache.commons.pool2.BaseObjectPool;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPSchemaCachingParserPool {
    private static Logger cat = LoggerFactory.getLogger(EPPSchemaCachingParserPool.class);
    private static EPPSchemaCachingParserPool instance = new EPPSchemaCachingParserPool();
    private SoftReferenceObjectPool<EPPSchemaCachingParser> pool = null;

    public static EPPSchemaCachingParserPool getInstance() {
        return instance;
    }

    private EPPSchemaCachingParserPool() {
        cat.info("EPPSchemaCachingParserPool: initializing pool with " + EPPEnv.getSchemaCachingParserPoolSize() + " parsers");
        this.pool = new SoftReferenceObjectPool((PooledObjectFactory)new EPPSchemaCachingParserPoolFactory());
        try {
            this.pool.addObjects(EPPEnv.getSchemaCachingParserPoolSize());
        }
        catch (Exception ex) {
            cat.error("EPPSchemaCachingParserPool: Exception initializing the EPPSchemaCachingParserPool: " + ex);
        }
        cat.info("EPPSchemaCachingParserPool: pool initialized");
    }

    public BaseObjectPool<EPPSchemaCachingParser> getPool() {
        return this.pool;
    }

    private static class EPPSchemaCachingParserPoolFactory
    extends BasePooledObjectFactory<EPPSchemaCachingParser> {
        private static Logger cat = LoggerFactory.getLogger(EPPSchemaCachingParserPoolFactory.class);

        private EPPSchemaCachingParserPoolFactory() {
        }

        public void activateObject(PooledObject<EPPSchemaCachingParser> aParser) throws Exception {
            cat.debug("Parser activating from the pool: " + aParser);
            super.activateObject(aParser);
        }

        public void destroyObject(PooledObject<EPPSchemaCachingParser> aParser) throws Exception {
            cat.debug("Parser being deleted from the pool: " + aParser);
            super.destroyObject(aParser);
        }

        public void passivateObject(PooledObject<EPPSchemaCachingParser> aParser) throws Exception {
            cat.debug("Parser being passivated in the pool: " + aParser);
            super.passivateObject(aParser);
        }

        public EPPSchemaCachingParser create() throws Exception {
            EPPSchemaCachingParser theParser = new EPPSchemaCachingParser();
            cat.debug("Parser created for the pool: " + theParser);
            return theParser;
        }

        public PooledObject<EPPSchemaCachingParser> wrap(EPPSchemaCachingParser aParser) {
            return new DefaultPooledObject((Object)aParser);
        }
    }
}

