/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.EPPClientTransIdGenerator;
import com.verisign.epp.pool.EPPPooledGenericSession;
import com.verisign.epp.pool.EPPSessionPoolException;
import com.verisign.epp.pool.EPPSessionPoolableFactory;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.client.EPPSSLConfig;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.transport.client.EPPSSLImpl;
import com.verisign.epp.util.Environment;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPSystemSessionPool {
    public static final long DEFAULT_ABSOLUTE_TIMEOUT = 86400000L;
    public static final long DEFAULT_IDLE_TIMEOUT = 600000L;
    public static final long DEFAULT_MAX_WAIT = 60000L;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = 60000L;
    public static final int DEFAULT_MAX_IDLE = 10;
    public static final int DEFAULT_MAX_TOTAL = 10;
    private static final boolean DEFAULT_INIT_MAX_TOTAL = false;
    public static final int DEFAULT_MIN_IDLE = 0;
    private static long TIMEOUT_UNSET = -1L;
    private static final int DEFAULT_BORROW_RETRIES = 0;
    private static final String PROP_PREFIX = "EPP.SessionPool";
    private static Logger log = LoggerFactory.getLogger(EPPSystemSessionPool.class);
    private EPPSSLContext sslContext = null;
    private GenericObjectPool<EPPPooledGenericSession> pool = null;
    private GenericObjectPoolConfig<EPPPooledGenericSession> config = new GenericObjectPoolConfig();
    private EPPSessionPoolableFactory factory = new EPPSessionPoolableFactory();
    private boolean initMaxTotal = false;
    private int borrowRetries = 0;
    private String clientId;
    private String password;
    private long idleTimeout;
    private long absoluteTimeout = TIMEOUT_UNSET;
    private long minAbsoluteTimeout = TIMEOUT_UNSET;
    private long maxAbsoluteTimeout = TIMEOUT_UNSET;
    private String system;
    private String serverName;
    private Integer serverPort;
    private String clientHost = null;

    EPPSystemSessionPool(String aSystem) {
        this.system = aSystem;
    }

    public void init(EPPSessionPoolableFactory aFactory, GenericObjectPoolConfig<EPPPooledGenericSession> aConfig) {
        this.pool = new GenericObjectPool((PooledObjectFactory)aFactory, aConfig);
    }

    public void init() throws EPPSessionPoolException {
        try {
            this.clientId = this.getProperty("clientId");
            if (this.clientId == null) {
                log.error("EPPSystemSessionPool.init(): system = " + this.system + ": clientId not defined");
                throw new EPPSessionPoolException("clientId not defined");
            }
            this.password = this.getProperty("password");
            if (this.password == null) {
                log.error("EPPSystemSessionPool.init(): system = " + this.system + ": password not defined");
                throw new EPPSessionPoolException("password not defined");
            }
            String theValue = this.getProperty("absoluteTimeout");
            if (theValue != null) {
                this.absoluteTimeout = Long.parseLong(theValue);
                log.info("init(): system = " + this.system + ": absolute timeout = " + this.absoluteTimeout + " ms");
            } else {
                this.absoluteTimeout = 86400000L;
                log.info("init(): system = " + this.system + ": default absolute timeout = " + this.absoluteTimeout + " ms");
            }
            theValue = this.getProperty("minAbsoluteTimeout");
            if (theValue != null) {
                this.minAbsoluteTimeout = Long.parseLong(theValue);
                log.info("init(): system = " + this.system + ": min absolute timeout = " + this.minAbsoluteTimeout + " ms");
            } else {
                log.info("init(): system = " + this.system + ": min absolute timeout not set");
            }
            theValue = this.getProperty("maxAbsoluteTimeout");
            if (theValue != null) {
                this.maxAbsoluteTimeout = Long.parseLong(theValue);
                log.info("init(): system = " + this.system + ": max absolute timeout = " + this.maxAbsoluteTimeout + " ms");
            } else {
                log.info("init(): system = " + this.system + ": max absolute timeout not set");
            }
            theValue = this.getProperty("idleTimeout");
            this.idleTimeout = theValue != null ? Long.parseLong(theValue) : 600000L;
            log.info("init(): system = " + this.system + ": idle timeout = " + this.idleTimeout + " ms");
            theValue = this.getProperty("clientTransIdGenerator");
            log.info("init(): system = " + this.system + ": client trans id generator = " + theValue);
            if (theValue != null) {
                try {
                    this.factory.setClientTransIdGenerator((EPPClientTransIdGenerator)Class.forName(theValue).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception ex) {
                    log.error("EPPSystemSessionPool.init(): Exception creating instance of class " + theValue + ": " + ex);
                    throw new EPPSessionPoolException("Exception creating instance of class " + theValue + ": " + ex);
                }
            }
            this.serverName = this.getProperty("serverName");
            if (this.serverName == null) {
                log.error("EPPSystemSessionPool.init(): system = " + this.system + ": serverName not defined");
                throw new EPPSessionPoolException("serverName not defined");
            }
            log.info("init(): system = " + this.system + ": serverName = " + this.serverName);
            theValue = this.getProperty("serverPort");
            if (theValue != null) {
                this.serverPort = Integer.valueOf(theValue);
            }
            log.info("init(): system = " + this.system + ": serverPort = " + this.serverPort);
            this.clientHost = this.getProperty("clientHost");
            log.info("init(): system = " + this.system + ": clientHost = " + this.clientHost);
            this.config.setMinEvictableIdleTimeMillis(0L);
            theValue = this.getProperty("maxIdle");
            if (theValue != null) {
                this.config.setMaxIdle(Integer.parseInt(theValue));
            } else {
                this.config.setMaxIdle(10);
            }
            log.info("init(): system = " + this.system + ": max idle = " + this.config.getMaxIdle());
            theValue = this.getProperty("maxTotal");
            if (theValue == null) {
                theValue = this.getProperty("maxActive");
            }
            if (theValue != null) {
                this.config.setMaxTotal(Integer.parseInt(theValue));
            } else {
                this.config.setMaxTotal(10);
            }
            log.info("init(): system = " + this.system + ": max total = " + this.config.getMaxTotal());
            theValue = this.getProperty("initMaxTotal");
            if (theValue == null) {
                theValue = this.getProperty("initMaxActive");
            }
            this.initMaxTotal = theValue != null ? Boolean.valueOf(theValue) : false;
            log.info("init(): system = " + this.system + ": init max total = " + this.initMaxTotal);
            theValue = this.getProperty("borrowRetries");
            this.borrowRetries = theValue != null ? Integer.parseInt(theValue) : 0;
            log.info("init(): system = " + this.system + ": borrow retries = " + this.borrowRetries);
            theValue = this.getProperty("maxWait");
            if (theValue != null) {
                this.config.setMaxWaitMillis((long)Integer.parseInt(theValue));
            } else {
                this.config.setMaxWaitMillis(60000L);
            }
            log.info("init(): system = " + this.system + ": max wait = " + this.config.getMaxWaitMillis());
            theValue = this.getProperty("minIdle");
            if (theValue != null) {
                this.config.setMinIdle(Integer.parseInt(theValue));
            } else {
                this.config.setMinIdle(0);
            }
            log.info("init(): system = " + this.system + ": min idle = " + this.config.getMinIdle());
            this.config.setNumTestsPerEvictionRun(-1);
            this.config.setTestOnBorrow(false);
            this.config.setTestOnReturn(false);
            this.config.setTestWhileIdle(true);
            theValue = this.getProperty("timeBetweenEvictionRunsMillis");
            if (theValue != null) {
                this.config.setTimeBetweenEvictionRunsMillis(Long.parseLong(theValue));
            } else {
                this.config.setTimeBetweenEvictionRunsMillis(60000L);
            }
            log.info("init(): system = " + this.system + ": time between eviction runs = " + this.config.getTimeBetweenEvictionRunsMillis() + " ms");
            this.config.setBlockWhenExhausted(true);
        }
        catch (Exception ex) {
            log.error("EPPSystemSessionPool.init(): system = " + this.system + ": Exception referencing Environment property: " + ex);
            throw new EPPSessionPoolException("Exception referencing Environment property: " + ex);
        }
        this.factory.setAbsoluteTimeout(this.absoluteTimeout);
        this.factory.setMinAbsoluteTimeout(this.minAbsoluteTimeout);
        this.factory.setMaxAbsoluteTimeout(this.maxAbsoluteTimeout);
        this.factory.setIdleTimeout(this.idleTimeout);
        this.factory.setClientId(this.clientId);
        this.factory.setPassword(this.password);
        this.factory.setServerName(this.serverName);
        this.factory.setServerPort(this.serverPort);
        this.factory.setClientHost(this.clientHost);
        if (this.getProperty("SSLProtocol") != null) {
            EPPSSLConfig theConfig = new EPPSSLConfig(this.getProperty("SSLProtocol"), this.getProperty("SSLKeyStore"), this.getProperty("SSLKeyFileName"), this.getProperty("SSLPassPhrase"));
            theConfig.setIdentityKeyPassPhrase(this.getProperty("SSLKeyPassPhrase"));
            theConfig.setSslDebug(this.getProperty("SSLDebug"));
            theConfig.setTrustStore(this.getProperty("SSLTrustStore"), this.getProperty("SSLTrustStoreFileName"), this.getProperty("SSLTrustStorePassPhrase"));
            theConfig.setSSLEnabledProtocols(this.getProperty("SSLEnabledProtocols"));
            theConfig.setSSLEnabledCipherSuites(this.getProperty("SSLEnabledCipherSuites"));
            try {
                this.sslContext = EPPSSLImpl.initialize(theConfig);
            }
            catch (EPPConException ex) {
                log.error("EPPSystemSessionPool.init(): system = " + this.system + ": Exception initializing EPPSSLContext: " + ex);
                throw new EPPSessionPoolException("EPPSystemSessionPool.init(): system = " + this.system + ": Exception initializing EPPSSLContext: " + ex);
            }
            this.factory.setSSLContext(this.sslContext);
        }
        this.init(this.factory, this.config);
        if (this.initMaxTotal && this.config.getMaxTotal() > 0) {
            int i;
            log.info("init(): system = " + this.system + ": Pre-initialize maxTotal (" + this.config.getMaxTotal() + ") sessions");
            EPPSession[] theSessions = new EPPSession[this.config.getMaxTotal()];
            for (i = 0; i < this.config.getMaxTotal(); ++i) {
                try {
                    theSessions[i] = this.borrowObject();
                    log.info("init(): system = " + this.system + ": Pre-initialized session #" + (i + 1));
                    continue;
                }
                catch (EPPSessionPoolException ex) {
                    log.error("init(): system = " + this.system + ": Failure to pre-initialize session #" + (i + 1) + ": " + ex);
                }
            }
            for (i = 0; i < this.config.getMaxTotal(); ++i) {
                if (theSessions[i] == null) continue;
                this.returnObject(theSessions[i]);
                theSessions[i] = null;
            }
        }
    }

    public void close() {
        log.info("close(): closing pool");
        if (this.pool != null) {
            this.pool.clear();
            try {
                this.pool.close();
            }
            catch (Exception ex) {
                log.error("EPPSystemSessionPool.close(): Exception closing pool <" + this.pool + ">: " + ex);
            }
        }
        log.info("close(): pool closed");
    }

    public EPPSession borrowObject() throws EPPSessionPoolException {
        if (this.pool == null) {
            log.error("borrowObject(): pool is null");
            throw new EPPSessionPoolException("EPPSystemSessionPool: pool is null");
        }
        EPPSession theSession = null;
        for (int retries = 0; theSession == null && retries <= this.borrowRetries; ++retries) {
            try {
                theSession = (EPPSession)this.pool.borrowObject();
                log.debug("borrowObject(): Session = " + theSession + ", Active = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle());
                continue;
            }
            catch (Exception ex) {
                if (retries >= this.borrowRetries) {
                    log.error("borrowObject(): Final exception on borrow session after " + retries + " retries: " + ex);
                    throw new EPPSessionPoolException("EPPSystemSessionPool: Exception " + ex);
                }
                log.debug("borrowObject(): Exception on borrow session after " + retries + " retries: " + ex);
            }
        }
        return theSession;
    }

    public void invalidateObject(EPPSession aSession) throws EPPSessionPoolException {
        if (!(aSession instanceof EPPPooledGenericSession)) {
            log.error("invalidateObject(" + aSession + "): session not of type " + EPPPooledGenericSession.class.getName());
            throw new EPPSessionPoolException("EPPSessionPool: session not of type " + EPPPooledGenericSession.class.getName());
        }
        try {
            this.pool.invalidateObject((Object)((EPPPooledGenericSession)aSession));
            log.debug("invalidateObject(" + aSession + "): Active = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle());
        }
        catch (Exception ex) {
            log.error("invalidateObject(" + aSession + "): Caught Exception: " + ex);
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public void returnObject(EPPSession aSession) throws EPPSessionPoolException {
        if (!(aSession instanceof EPPPooledGenericSession)) {
            log.error("invalidateObject(" + aSession + "): session not of type " + EPPPooledGenericSession.class.getName());
            throw new EPPSessionPoolException("EPPSessionPool: session not of type " + EPPPooledGenericSession.class.getName());
        }
        try {
            this.pool.returnObject((Object)((EPPPooledGenericSession)aSession));
            log.debug("returnObject(" + aSession + "): Active = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle());
        }
        catch (Exception ex) {
            log.error("returnObject(" + aSession + "): Caught Exception: " + ex);
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public GenericObjectPool<EPPPooledGenericSession> getGenericObjectPool() {
        return this.pool;
    }

    public long getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public String getClientId() {
        return this.clientId;
    }

    public GenericObjectPoolConfig<EPPPooledGenericSession> getConfig() {
        return this.config;
    }

    public EPPSessionPoolableFactory getFactory() {
        return this.factory;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSystem() {
        return this.system;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String aServerName) {
        this.serverName = aServerName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer aServerPort) {
        this.serverPort = aServerPort;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String aClientHost) {
        this.clientHost = aClientHost;
    }

    private String getProperty(String aProperty) {
        return Environment.getProperty("EPP.SessionPool." + this.system + "." + aProperty);
    }
}

