/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.pool.EPPClientTransIdGenerator;
import com.verisign.epp.pool.EPPPooledGenericSession;
import com.verisign.epp.pool.EPPSessionPoolException;
import com.verisign.epp.transport.client.EPPSSLContext;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPSessionPoolableFactory
implements PooledObjectFactory<EPPPooledGenericSession> {
    private static Logger log = LoggerFactory.getLogger(EPPSessionPoolableFactory.class);
    public static long TIMEOUT_UNSET = -1L;
    private String clientId;
    private String password;
    private long absoluteTimeout = TIMEOUT_UNSET;
    private long minAbsoluteTimeout = TIMEOUT_UNSET;
    private long maxAbsoluteTimeout = TIMEOUT_UNSET;
    private long idleTimeout = TIMEOUT_UNSET;
    private String serverName;
    private Integer serverPort;
    private String clientHost = null;
    private EPPSSLContext sslContext = null;
    private EPPClientTransIdGenerator clientTransIdGenerator = null;

    public EPPSessionPoolableFactory() {
    }

    public EPPSessionPoolableFactory(String aClientId, String aPassword, long aAbsoluteTimeout, long aIdleTimeout) {
        this.clientId = aClientId;
        this.password = aPassword;
        this.absoluteTimeout = aAbsoluteTimeout;
        this.idleTimeout = aIdleTimeout;
    }

    public EPPSessionPoolableFactory(String aClientId, String aPassword, long aMinAbsoluteTimeout, long aMaxAbsoluteTimeout, long aIdleTimeout) {
        this.clientId = aClientId;
        this.password = aPassword;
        this.minAbsoluteTimeout = aMinAbsoluteTimeout;
        this.maxAbsoluteTimeout = aMaxAbsoluteTimeout;
        this.idleTimeout = aIdleTimeout;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public void setAbsoluteTimeout(long aAbsoluteTimeout) {
        this.absoluteTimeout = aAbsoluteTimeout;
    }

    public long getMinAbsoluteTimeout() {
        return this.minAbsoluteTimeout;
    }

    public void setMinAbsoluteTimeout(long aMinAbsoluteTimeout) {
        this.minAbsoluteTimeout = aMinAbsoluteTimeout;
    }

    public long getMaxAbsoluteTimeout() {
        return this.maxAbsoluteTimeout;
    }

    public void setMaxAbsoluteTimeout(long aMaxAbsoluteTimeout) {
        this.maxAbsoluteTimeout = aMaxAbsoluteTimeout;
    }

    public boolean isRandomAbsoluteTimeout() {
        log.debug("isRandomAbsoluteTimeout: minAbsoluteTimeout = " + this.minAbsoluteTimeout + ", maxAbsoluteTimeout = " + this.maxAbsoluteTimeout);
        if (this.minAbsoluteTimeout != TIMEOUT_UNSET && this.maxAbsoluteTimeout != TIMEOUT_UNSET) {
            if (this.maxAbsoluteTimeout > this.minAbsoluteTimeout) {
                log.debug("isRandomAbsoluteTimeout: returning true");
                return true;
            }
            log.debug("isRandomAbsoluteTimeout: maxAbsoluteTimeout <= minAbsoluteTimeout: returning false");
            return false;
        }
        log.debug("isRandomAbsoluteTimeout: maxAbsoluteTimeout or minAbsoluteTimeout not set: returning false");
        return false;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long aIdleTimeout) {
        this.idleTimeout = aIdleTimeout;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String aServerName) {
        this.serverName = aServerName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer aServerPort) {
        this.serverPort = aServerPort;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String aClientHost) {
        this.clientHost = aClientHost;
    }

    public EPPSSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(EPPSSLContext aSSLContext) {
        this.sslContext = aSSLContext;
    }

    public EPPClientTransIdGenerator getClientTransIdGenerator() {
        return this.clientTransIdGenerator;
    }

    public void setClientTransIdGenerator(EPPClientTransIdGenerator aClientTransIdGenerator) {
        this.clientTransIdGenerator = aClientTransIdGenerator;
    }

    public void activateObject(PooledObject<EPPPooledGenericSession> aSession) throws Exception {
    }

    public void destroyObject(PooledObject<EPPPooledGenericSession> aSession) throws Exception {
        log.debug("destroyObject(): enter, sEPPPooledGenericSessionession id = " + aSession.getObject());
        EPPPooledGenericSession theSession = (EPPPooledGenericSession)aSession.getObject();
        try {
            if (this.clientTransIdGenerator != null) {
                theSession.setTransId(this.clientTransIdGenerator.genClientTransId());
            }
            log.debug("destroyObject(): enter, calling end session");
            theSession.endSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PooledObject<EPPPooledGenericSession> makeObject() throws Exception {
        log.debug("makeObject(): enter");
        EPPPooledGenericSession theSession = this.makeSession();
        log.debug("makeObject(): Make session with id = " + theSession);
        theSession.setClientID(this.clientId);
        theSession.setPassword(this.password);
        if (this.clientTransIdGenerator != null) {
            theSession.setTransId(this.clientTransIdGenerator.genClientTransId());
        }
        log.debug("makeObject(): establishing session, with session class " + theSession.getClass().getName());
        try {
            theSession.initSession();
            log.debug("makeObject(): established session, with session class " + theSession.getClass().getName());
        }
        catch (EPPCommandException ex) {
            log.error("makeObject(): error initializing session " + theSession.getClass().getName() + ": " + ex);
            try {
                theSession.endConnection();
            }
            catch (EPPCommandException ePPCommandException) {
                // empty catch block
            }
            throw ex;
        }
        log.debug("makeObject(): exit");
        return new DefaultPooledObject((Object)theSession);
    }

    public void passivateObject(PooledObject<EPPPooledGenericSession> aSession) throws Exception {
    }

    public boolean validateObject(PooledObject<EPPPooledGenericSession> aSession) {
        boolean isValid;
        log.debug("validateObject(): enter, session id = " + aSession);
        EPPPooledGenericSession theSession = (EPPPooledGenericSession)aSession.getObject();
        long currentTime = System.currentTimeMillis();
        try {
            if (currentTime - theSession.getCreatedTime() > theSession.getAbsoluteTimeout()) {
                log.debug("validateObject(): session id = " + aSession + " is past absolute timeout");
                isValid = false;
            } else if (System.currentTimeMillis() - theSession.getLastTouched() > this.getIdleTimeout()) {
                log.debug("validateObject(): session id = " + aSession + " is past idle timeout, sending hello");
                theSession.hello();
                theSession.touch();
                isValid = true;
            } else {
                log.debug("validateObject(): session id = " + aSession + " is valid");
                isValid = true;
            }
        }
        catch (Exception ex) {
            log.debug("validateObject(): session id = " + aSession + " caused Exception: " + ex);
            isValid = false;
        }
        log.debug("validateObject(): exit, isValid = " + isValid);
        return isValid;
    }

    protected EPPPooledGenericSession makeSession() throws Exception {
        log.debug("makeSession(): enter");
        EPPPooledGenericSession session = null;
        if (this.serverName == null || this.serverPort == null) {
            throw new EPPSessionPoolException("makeSession(): serverName or serverPort is null");
        }
        session = this.clientHost == null ? new EPPPooledGenericSession(this.serverName, (int)this.serverPort, this.sslContext) : new EPPPooledGenericSession(this.serverName, this.serverPort, this.clientHost, this.sslContext);
        if (this.isRandomAbsoluteTimeout()) {
            long theAbsoluteTimeout = ThreadLocalRandom.current().nextLong(this.minAbsoluteTimeout, this.maxAbsoluteTimeout + 1L);
            log.debug("makeSession(): setting random absolute timeout (ms) = " + theAbsoluteTimeout);
            session.setAbsoluteTimeout(theAbsoluteTimeout);
        } else {
            log.debug("makeSession(): setting absolute timeout (ms) = " + this.absoluteTimeout);
            session.setAbsoluteTimeout(this.absoluteTimeout);
        }
        return session;
    }
}

