/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.namestore.interfaces;

import com.verisign.epp.codec.contact.EPPContactTransferResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollResponse;
import com.verisign.epp.codec.rgppoll.EPPRgpPollResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.namestore.interfaces.NSDomain;
import com.verisign.epp.pool.EPPSessionPool;
import com.verisign.epp.util.InvalidateSessionException;
import com.verisign.epp.util.TestThread;
import com.verisign.epp.util.TestUtil;
import java.util.Random;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSPollTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(NSPollTst.class);
    private static EPPSessionPool sessionPool = null;
    private Random rd = new Random(System.currentTimeMillis());

    public NSPollTst(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPoll() {
        NSPollTst.printStart("testPoll");
        EPPSession theSession = null;
        try {
            theSession = this.borrowSession();
            EPPResponse theResponse = null;
            Object numMsgs = null;
            try {
                NSDomain theDomain = new NSDomain(theSession);
                theDomain.addDomainName("NSPollTst.com");
                theDomain.setAuthString("MyAuth");
                theDomain.sendCreate();
                theSession.setTransId("ABC-12345-XYZ");
                theSession.setPollOp("req");
                theResponse = theSession.sendPoll();
                while (theResponse.getResult().getCode() == 1301) {
                    String theStatus;
                    EPPResponse theMsg;
                    System.out.println("testPoll: Poll Response = [" + theResponse + "]\n\n");
                    if (theResponse instanceof EPPDomainTransferResp) {
                        System.out.println("testPoll: Got domain transfer notification");
                        theMsg = (EPPDomainTransferResp)theResponse;
                        theStatus = ((EPPDomainTransferResp)theMsg).getTransferStatus();
                        if (theStatus.equals("pending")) {
                            System.out.println("testPoll: Got domain transfer request notification");
                        } else if (theStatus.equals("clientApproved")) {
                            System.out.println("testPoll: Got domain transfer approve notification");
                        } else if (theStatus.equals("clientCancelled")) {
                            System.out.println("testPoll: Got domain transfer cancelled notification");
                        } else if (theStatus.equals("clientRejected")) {
                            System.out.println("testPoll: Got domain transfer rejected notification");
                        } else if (theStatus.equals("serverApproved")) {
                            System.out.println("testPoll: Got domain transfer auto approve notification");
                        } else if (theStatus.equals("serverCancelled")) {
                            System.out.println("testPoll: Got domain transfer auto cancelled notification");
                        } else {
                            System.out.println("testPoll: Unknown domain transfer status [" + theStatus + "]");
                        }
                    } else if (theResponse instanceof EPPContactTransferResp) {
                        System.out.println("testPoll: Got contact transfer notification");
                        theMsg = (EPPContactTransferResp)theResponse;
                        theStatus = ((EPPContactTransferResp)theMsg).getTransferStatus();
                        if (theStatus.equals("pending")) {
                            System.out.println("testPoll: Got contact transfer request notification");
                        } else if (theStatus.equals("clientApproved")) {
                            System.out.println("testPoll: Got contact transfer approve notification");
                        } else if (theStatus.equals("clientCancelled")) {
                            System.out.println("testPoll: Got contact transfer cancelled notification");
                        } else if (theStatus.equals("clientRejected")) {
                            System.out.println("testPoll: Got contact transfer rejected notification");
                        } else if (theStatus.equals("serverApproved")) {
                            System.out.println("testPoll: Got contact transfer auto approve notification");
                        } else if (theStatus.equals("serverCancelled")) {
                            System.out.println("testPoll: Got contact transfer auto cancelled notification");
                        } else {
                            System.out.println("testPoll: Unknown contact transfer status [" + theStatus + "]");
                        }
                    } else if (theResponse instanceof EPPLowBalancePollResponse) {
                        System.out.println("testPoll: Got low balance notification");
                    } else if (theResponse instanceof EPPRgpPollResponse) {
                        System.out.println("testPoll: Got RGP notification");
                    } else if (theResponse instanceof EPPDomainPendActionMsg) {
                        System.out.println("testPoll: Got domain pending action notification");
                    } else {
                        System.out.println("testPoll: Got general notification");
                        String msg = theResponse.getMsgQueueMsg();
                        System.out.println("Poll msg = " + msg);
                        if (msg.startsWith("\"notification\"")) {
                            // empty if block
                        }
                    }
                    theSession.setPollOp("ack");
                    theSession.setMsgID(theResponse.getMsgQueue().getId());
                    theResponse = theSession.sendPoll();
                    System.out.println("doPoll: Poll ACK Response = [" + theResponse + "]\n\n");
                    theSession.setPollOp("req");
                    theResponse = theSession.sendPoll();
                }
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSPollTst.printEnd("testPoll");
    }

    public void testEndSession() {
        NSPollTst.printStart("testEndSession");
        EPPSession theSession = null;
        try {
            theSession = this.borrowSession();
            sessionPool.invalidateObject(theSession);
            theSession = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("testEndSession(): Exception invalidating session: " + ex));
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSPollTst.printEnd("testEndSession");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        return new NSPollTstSetup((Test)new TestSuite(NSPollTst.class));
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("NSPollTst Thread " + i, NSPollTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)NSPollTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info(Thread.currentThread().getName() + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info(Thread.currentThread().getName() + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private EPPSession borrowSession() {
        EPPSession theSession = null;
        try {
            theSession = sessionPool.borrowObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("borrowSession(): Exception borrowing session: " + ex));
        }
        return theSession;
    }

    private void returnSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.returnObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("returnSession(): Exception returning session: " + ex));
        }
    }

    private void invalidateSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.invalidateObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("invalidateSession(): Exception invalidating session: " + ex));
        }
    }

    private void handleResponse(EPPResponse aResponse) {
        for (int i = 0; i < aResponse.getResults().size(); ++i) {
            EPPResult theResult = (EPPResult)aResponse.getResults().elementAt(i);
            System.out.println("Result Code    : " + theResult.getCode());
            System.out.println("Result Message : " + theResult.getMessage());
            System.out.println("Result Lang    : " + theResult.getLang());
            if (theResult.isSuccess()) {
                System.out.println("Command Passed ");
            } else {
                System.out.println("Command Failed ");
            }
            if (theResult.getAllValues() == null) continue;
            for (int k = 0; k < theResult.getAllValues().size(); ++k) {
                System.out.println("Result Values  : " + theResult.getAllValues().elementAt(k));
            }
        }
    }

    private static class NSPollTstSetup
    extends TestSetup {
        public NSPollTstSetup(Test aTest) {
            super(aTest);
        }

        protected void setUp() throws Exception {
            super.setUp();
            String theConfigFileName = System.getProperty("EPP.ConfigFile");
            if (theConfigFileName != null) {
                configFileName = theConfigFileName;
            }
            try {
                app.initialize(configFileName);
            }
            catch (EPPCommandException e) {
                e.printStackTrace();
                Assert.fail((String)("Error initializing the EPP Application: " + e));
            }
            try {
                sessionPool = EPPSessionPool.getInstance();
                sessionPool.init();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)("Error initializing the session pool: " + ex));
            }
        }

        protected void tearDown() throws Exception {
            super.tearDown();
            EPPSessionPool.getInstance().close();
        }
    }
}

