/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.eai.v1_0;

import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPContact;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPEAITst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPEAITst.class);
    private EPPContact contact = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPEAITst(String name) {
        super(name);
    }

    public void testContact() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.contactCreate();
            this.contactUpdate();
            this.contactInfo();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void contactCreate() {
        EPPResponse response;
        EPPContactPostalDefinition name;
        EPPContactAddress address;
        Vector<String> streets;
        this.printStart("contactCreate");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCreate: Contact create for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientXYZ");
            this.contact.addContactId(theName);
            this.contact.setVoicePhone("+1.7035555555");
            this.contact.setVoiceExt("123");
            this.contact.setFaxNumber("+1.7035555556");
            this.contact.setFaxExt("456");
            this.contact.setEmail("D\u00f6rteS\u00f6rensen@example.com");
            streets = new Vector();
            streets.addElement("123 Example Dr.");
            streets.addElement("Suite 100");
            streets.addElement("This is third line");
            address = new EPPContactAddress();
            address.setStreets(streets);
            address.setCity("Dulles");
            address.setStateProvince("VA");
            address.setPostalCode("20166-6503");
            address.setCountry("US");
            name = new EPPContactPostalDefinition("loc");
            name.setName("D\u00f6rte S\u00f6rense");
            name.setOrg("Example Inc.");
            name.setAddress(address);
            this.contact.addPostalInfo(name);
            response = this.contact.sendCreate();
            System.out.println("contactCreate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCreate: Contact create of unsupported EAI contact \"EAI-notsupported\"");
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientXYZ");
            this.contact.addContactId("EAI-notsupported");
            this.contact.setEmail("D\u00f6rteS\u00f6rensen@example.com");
            streets = new Vector<String>();
            streets.addElement("123 Example Dr.");
            address = new EPPContactAddress();
            address.setStreets(streets);
            address.setCity("Dulles");
            address.setStateProvince("VA");
            address.setPostalCode("20166-6503");
            address.setCountry("US");
            name = new EPPContactPostalDefinition("loc");
            name.setName("D\u00f6rte S\u00f6rense");
            name.setAddress(address);
            this.contact.addPostalInfo(name);
            response = this.contact.sendCreate();
            Assert.fail((String)("contactCreate: Unexpected successful response = [" + response + "]"));
        }
        catch (EPPCommandException e) {
            EPPResponse theResponse = e.getResponse();
            if (theResponse != null) {
                Assert.assertEquals((int)2308, (int)theResponse.getResult().getCode());
                System.out.println("contactCreate: Expected Error Response = [" + theResponse + "]\n\n");
            }
            this.handleException(e);
        }
        this.printEnd("contactCreate");
    }

    public void contactUpdate() {
        EPPResponse response;
        this.printStart("contactUpdate");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactUpdate: Contact update for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            this.contact.setEmail("D\u00f6rteS\u00f6rensen2@example.com");
            response = this.contact.sendUpdate();
            System.out.println("contactUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactUpdate: Contact update of unsupported EAI contact \"EAI-notsupported\"");
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId("EAI-notsupported");
            this.contact.setEmail("D\u00f6rteS\u00f6rensen2@example.com");
            response = this.contact.sendUpdate();
            Assert.fail((String)("contactUpdate: Unexpected successful response = [" + response + "]"));
        }
        catch (EPPCommandException e) {
            EPPResponse theResponse = e.getResponse();
            if (theResponse != null) {
                Assert.assertEquals((int)2308, (int)theResponse.getResult().getCode());
                System.out.println("contactUpdate: Expected Error Response = [" + theResponse + "]\n\n");
            }
            this.handleException(e);
        }
        this.printEnd("contactUpdate");
    }

    public void contactInfo() {
        EPPContactInfoResp response;
        this.printStart("contactInfo");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactInfo: Contact info for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            response = this.contact.sendInfo();
            System.out.println("contactInfo: Response = [" + response + "]\n\n");
            System.out.println("contactInfo: id = " + response.getId());
            Assert.assertNotNull((Object)response.getEmail());
            System.out.println("contactInfo: email = " + response.getEmail());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactInfo: Contact info of unsupported EAI contact \"EAI-notsupported\"");
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId("EAI-notsupported");
            response = this.contact.sendInfo();
            Assert.fail((String)("contactInfo: Unexpected successful response = [" + response + "]"));
        }
        catch (EPPCommandException e) {
            EPPResponse theResponse = e.getResponse();
            if (theResponse != null) {
                Assert.assertEquals((int)2308, (int)theResponse.getResult().getCode());
                System.out.println("contactInfo: Expected Error Response = [" + theResponse + "]\n\n");
            }
            this.handleException(e);
        }
        this.printEnd("contactInfo");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.contact = new EPPContact(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPEAITst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPEAITst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPEAITst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("EAI" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

