/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.client.EPPSSLClientSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class RenegotiationSession
extends EPPSession {
    private static Logger cat = LoggerFactory.getLogger(RenegotiationSession.class);

    @Override
    public void sendDocument(Document aDocument, EPPMessage aMessage) throws EPPCommandException {
        cat.debug("sendDocument(): enter");
        if (this.connection instanceof EPPSSLClientSocket) {
            try {
                ((EPPSSLClientSocket)this.connection).getSocket().startHandshake();
                super.sendDocument(aDocument, aMessage);
            }
            catch (EPPCommandException ex) {
                cat.error("sendDocument(): Exception executing client-initiated renegotiation: " + ex);
                throw ex;
            }
            catch (Exception ex) {
                cat.error("sendDocument(): Exception executing client-initiated renegotiation: " + ex);
                throw new EPPCommandException("RenegotiationSession.sendPacket() : " + ex.getMessage(), ex);
            }
            cat.info("sendDocument(): Executed client-initiated renegotiation successfully");
        } else {
            super.sendDocument(aDocument, aMessage);
        }
        cat.debug("sendDocument(): exit");
    }
}

