/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.RenegotiationSession;
import com.verisign.epp.transport.client.EPPSSLClientSocket;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import javax.net.ssl.SSLHandshakeException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EPPSessionTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPSessionTst.class);
    private EPPSession session = null;

    public EPPSessionTst(String name) {
        super(name);
    }

    public void testSession() {
        this.initSession();
        this.doHello();
        this.doPoll();
        this.doPollConsume();
        this.doAsyncPoll();
        this.doSendPacket();
        this.doSendInvalidRequest();
        this.endSession();
    }

    public void testClientInitiatedRenegotation() {
        EPPSessionTst.printStart("testClientInitiatedRenegotation");
        RenegotiationSession theSession = null;
        try {
            theSession = new RenegotiationSession();
            String theClientId = Environment.getProperty("EPP.Test.clientId", "ClientX");
            String thePassword = Environment.getProperty("EPP.Test.password", "foo-BAR2");
            theSession.setClientID(theClientId);
            theSession.setPassword(thePassword);
            theSession.setTransId("ABC-12345-XYZ");
            theSession.setVersion("1.0");
            theSession.setLang("en");
            theSession.initSession();
            if (theSession.getClientCon() instanceof EPPSSLClientSocket) {
                Assert.fail((String)"testClientInitiatedRenegotation: Client-initiated renegotiation unexpectedly successful");
            }
        }
        catch (EPPCommandException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof SSLHandshakeException) {
                cat.info("testClientInitiatedRenegotation: Successfully failed with cause = " + ex.getCause());
                System.out.println(Thread.currentThread().getName() + ": testClientInitiatedRenegotation: Successfully failed with cause = " + ex.getCause());
            }
            this.handleException(ex);
        }
        EPPSessionTst.printEnd("testClientInitiatedRenegotation");
    }

    private void initSession() {
        EPPSessionTst.printStart("initSession");
        String theClientId = Environment.getProperty("EPP.Test.clientId", "ClientX");
        String thePassword = Environment.getProperty("EPP.Test.password", "foo-BAR2");
        this.session.setClientID(theClientId);
        this.session.setPassword(thePassword);
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        EPPSessionTst.printEnd("initSession");
    }

    private void doHello() {
        EPPSessionTst.printStart("Session Hello");
        try {
            this.session.hello();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        EPPSessionTst.printEnd("Session Hello");
    }

    private void doSendPacket() {
        EPPSessionTst.printStart("doSendPacket");
        try {
            this.session.sendPacket("<?xml version=\"1.0\" encoding=\"UTF-8\"?><epp xmlns=\"urn:ietf:params:xml:ns:epp-1.0\"><hello/></epp>".getBytes());
            Document theDoc = null;
            theDoc = this.session.recDocument();
            try {
                EPPGreeting greeting = (EPPGreeting)EPPCodec.getInstance().decode(theDoc);
                System.out.println("doSendPacket: Greeting = [" + greeting + "]\n\n");
            }
            catch (EPPDecodeException ex) {
                Assert.fail((String)"doSendPacket(); Error reading the greeting after a hello");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        EPPSessionTst.printEnd("doSendPacket");
    }

    private void doSendInvalidRequest() {
        EPPSessionTst.printStart("doSendInvalidRequest");
        try {
            this.session.sendMessage(new EPPResponse());
            Document theDoc = null;
            theDoc = this.session.recDocument();
            try {
                EPPResponse response = (EPPResponse)EPPCodec.getInstance().decode(theDoc);
                System.out.println("doSendInvalidRequest: Response = [" + response + "]\n\n");
                if (response.isSuccess()) {
                    Assert.fail((String)"doSendInvalidRequest(); Error receiving successful response after sending invalid request (response)");
                }
            }
            catch (EPPDecodeException ex) {
                Assert.fail((String)"doSendInvalidRequest(); Error reading the response after sending invalid request (response)");
            }
            EPPGreeting greeting = new EPPGreeting();
            greeting.setServer("doSendInvalidRequest");
            this.session.sendMessage(greeting);
            theDoc = null;
            theDoc = this.session.recDocument();
            try {
                EPPResponse response = (EPPResponse)EPPCodec.getInstance().decode(theDoc);
                System.out.println("doSendInvalidRequest: Response = [" + response + "]\n\n");
                if (response.isSuccess()) {
                    Assert.fail((String)"doSendInvalidRequest(); Error receiving successful response after sending invalid request (greeting)");
                }
            }
            catch (EPPDecodeException ex) {
                Assert.fail((String)"doSendInvalidRequest(); Error reading the response after sending invalid request (greeting)");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            Assert.fail((String)("doSendInvalidRequest(); General exception: " + e));
        }
        EPPSessionTst.printEnd("doSendInvalidRequest");
    }

    private void doPoll() {
        EPPSessionTst.printStart("doPoll");
        EPPResponse response = null;
        Long numMsgs = null;
        try {
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            System.out.println("doPoll: Response = [" + response + "]\n\n");
            numMsgs = response.getMsgQueueCount();
            if (numMsgs != null) {
                System.out.println("doPoll: # messages = " + numMsgs);
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setPollOp("ack");
            this.session.setMsgID("1234");
            response = this.session.sendPoll();
            System.out.println("doPoll: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            System.out.println("doPoll: Error Response = [" + e.getResponse() + "]\n\n");
        }
        EPPSessionTst.printEnd("doPoll");
    }

    private void doPollConsume() {
        EPPSessionTst.printStart("doPollConsume");
        EPPResponse response = null;
        try {
            this.session.setTransId("ABC-" + System.currentTimeMillis());
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            while (response.getResult().getCode() == 1301) {
                System.out.println("doPollConsume: Message = [" + response + "]\n\n");
                this.session.setTransId("ABC-" + System.currentTimeMillis());
                this.session.setPollOp("ack");
                this.session.setMsgID(response.getMsgQueue().getId());
                response = this.session.sendPoll();
                this.session.setTransId("ABC-" + System.currentTimeMillis());
                this.session.setPollOp("req");
                response = this.session.sendPoll();
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        EPPSessionTst.printEnd("doPollConsume");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncPoll() {
        EPPSessionTst.printStart("doAsyncPoll");
        if (!this.session.isModeSupported(1)) {
            System.out.println("doAsyncPoll: Session " + this.session.getClass().getName() + " does not support MODE_ASYNC, skipping test");
            EPPSessionTst.printEnd("doAsyncPoll (skipped)");
            return;
        }
        int previousSessionMode = this.session.setMode(1);
        try {
            String theClientTransId = "ASYNC-CMD-" + System.currentTimeMillis();
            this.session.setTransId(theClientTransId);
            this.session.setPollOp("req");
            EPPResponse thePollResp = this.session.sendPoll();
            Assert.assertNull((String)("doAsyncPoll: sendPoll() response " + thePollResp + " != null"), (Object)thePollResp);
            EPPResponse theResponse = this.session.readResponse();
            Assert.assertEquals((String)"doAsyncPoll: clientTransId's don't Match (command and response)", (String)theClientTransId, (String)theResponse.getTransId().getClientTransId());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        finally {
            this.session.setMode(previousSessionMode);
        }
        EPPSessionTst.printEnd("doAsyncPoll");
    }

    private void endSession() {
        EPPSessionTst.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        EPPSessionTst.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
    }

    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPSessionTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPSessionTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSessionTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public void handleException(EPPCommandException aException) {
        EPPResponse response = this.session.getResponse();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            aException.printStackTrace();
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info(Thread.currentThread().getName() + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info(Thread.currentThread().getName() + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }
}

