/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.rgpext.EPPRgpExtInfData;
import com.verisign.epp.codec.rgpext.EPPRgpExtReport;
import com.verisign.epp.codec.rgpext.EPPRgpExtReportText;
import com.verisign.epp.codec.rgpext.EPPRgpExtRestore;
import com.verisign.epp.codec.rgpext.EPPRgpExtStatus;
import com.verisign.epp.codec.rgpext.EPPRgpExtUpdate;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPRgpDomainTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPRgpDomainTst.class);
    private EPPDomain domain = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPRgpDomainTst(String name) {
        super(name);
    }

    public void testDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.domainRestoreRequest();
            this.domainRestoreReport();
            this.domainInfo();
            this.domainPoll();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void domainInfo() {
        this.printStart("domainInfo");
        try {
            System.out.println("\ndomainInfo: Domain info");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            EPPDomainInfoResp response = this.domain.sendInfo();
            System.out.println("domainInfo: Response = [" + response + "]\n\n");
            System.out.println("domainInfo: name = " + response.getName());
            System.out.println("domainInfo: client id = " + response.getClientId());
            System.out.println("domainInfo: created by = " + response.getCreatedBy());
            System.out.println("domainInfo: create date = " + response.getCreatedDate());
            System.out.println("domainInfo: expiration date = " + response.getExpirationDate());
            this.printRgpStatuses(response);
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName("graceperiod.com");
            response = this.domain.sendInfo();
            System.out.println("domainInfo: Response for graceperiod.com = [" + response + "]\n\n");
            this.printRgpStatuses(response);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainInfo");
    }

    public void domainRestoreRequest() {
        this.printStart("domainRestoreRequest");
        try {
            this.domain.setTransId("ABC-12345-XYZ");
            String myDomainName = this.makeDomainName();
            this.domain.addDomainName(myDomainName);
            this.domain.addExtension(new EPPRgpExtUpdate(new EPPRgpExtRestore()));
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainRestoreRequest: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainRestoreRequest");
    }

    public void domainRestoreReport() {
        this.printStart("domainRestoreReport");
        try {
            this.domain.setTransId("ABC-12345-XYZ");
            String myDomainName = this.makeDomainName();
            this.domain.addDomainName(myDomainName);
            EPPRgpExtReport report = new EPPRgpExtReport();
            report.setPreData("Pre-delete whois data goes here. Both XML and free text are allowed");
            report.setPostData("Post-delete whois data goes here. Both XML and free text are allowed");
            report.setDeleteTime(new Date());
            report.setRestoreTime(new Date());
            report.setRestoreReason(new EPPRgpExtReportText("Registrant Error"));
            report.setStatement1(new EPPRgpExtReportText("This registrar has not restored the Registered Domain in order to assume the rights to use or sell the Registered Name for itself or for any third party"));
            report.setStatement2(new EPPRgpExtReportText("The information in this report  is true to best of this registrar's knowledge, and thisregistrar acknowledges that intentionally supplying false information in this report shall constitute  an incurable material breach of the Registry-Registrar Agreement"));
            report.setOther("other stuff");
            EPPRgpExtRestore restore = new EPPRgpExtRestore(report);
            this.domain.addExtension(new EPPRgpExtUpdate(restore));
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainRestoreReport: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainRestoreReport");
    }

    public void domainPoll() {
        this.printStart("domainPoll");
        EPPResponse response = null;
        try {
            System.out.println("\ndomainPoll: Domain Poll");
            this.session.setTransId("AB-12345");
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            System.out.println("domainPoll: Response = [" + response + "]\n\n");
            this.session.setPollOp("ack");
            this.session.setMsgID(response.getMsgQueue().getId());
            response = this.session.sendPoll();
            System.out.println("domainPoll: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException ex) {
            this.handleException(ex);
        }
        this.printEnd("domainPoll");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPRgpDomainTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPRgpDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPRgpDomainTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }

    private void printRgpStatuses(EPPDomainInfoResp aResp) {
        if (aResp.hasExtension(EPPRgpExtInfData.class)) {
            EPPRgpExtInfData theRgpInf = (EPPRgpExtInfData)aResp.getExtension(EPPRgpExtInfData.class);
            Vector rgpStatuses = theRgpInf.getStatuses();
            System.out.println("domainInfo: rgpStatuses.size = " + rgpStatuses.size());
            for (int i = 0; i < rgpStatuses.size(); ++i) {
                EPPRgpExtStatus rgpStatus = (EPPRgpExtStatus)rgpStatuses.get(i);
                if (rgpStatus.getStatus().equals("addPeriod") || rgpStatus.getStatus().equals("autoRenewPeriod") || rgpStatus.getStatus().equals("renewPeriod") || rgpStatus.getStatus().equals("transferPeriod")) {
                    System.out.println("domainInfo: rgp grace period status " + rgpStatus.getStatus());
                    System.out.println("domainInfo: rgp grace period end date = " + EPPUtil.decodeTimeInstant(rgpStatus.getMessage().substring(8)));
                    continue;
                }
                if (!rgpStatus.getStatus().equals("redemptionPeriod") && !rgpStatus.getStatus().equals("pendingRestore") && !rgpStatus.getStatus().equals("pendingDelete")) continue;
                System.out.println("domainInfo: rgp pending period status " + rgpStatus.getStatus());
            }
        }
    }
}

