/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.orgext.EPPOrgExtCreate;
import com.verisign.epp.codec.orgext.EPPOrgExtId;
import com.verisign.epp.codec.orgext.EPPOrgExtInfData;
import com.verisign.epp.codec.orgext.EPPOrgExtUpdate;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPOrgExtDomainTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPOrgExtDomainTst.class);
    private EPPDomain domain = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPOrgExtDomainTst(String name) {
        super(name);
    }

    public void testDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.domainInfo();
            this.domainCreate();
            this.domainUpdate();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void domainInfo() {
        this.printStart("domainInfo");
        try {
            System.out.println("\ndomainInfo: Domain info for org.example to get the info response with the <code>EPPOrgExt</code> extension.");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.com");
            EPPDomainInfoResp response = this.domain.sendInfo();
            System.out.println("domainInfo: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPOrgExtInfData.class)) {
                EPPOrgExtInfData theExt = (EPPOrgExtInfData)response.getExtension(EPPOrgExtInfData.class);
                if (theExt.hasOrgIds()) {
                    for (EPPOrgExtId theOrgId : theExt.getOrgIds()) {
                        System.out.println("domainInfo: orgext response : org role = " + theOrgId.getRole());
                        System.out.println("domainInfo: orgext response : org identifer = " + theOrgId.getOrgId());
                    }
                }
            } else {
                System.out.println("domainInfo: Response did not contain org extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainInfo");
    }

    public void domainCreate() {
        this.printStart("domainCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCreate: Create domain with EPPOrgExt extension");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.com");
            this.domain.setAuthString("fooBAR");
            this.domain.addExtension(new EPPOrgExtCreate(new EPPOrgExtId("reseller", "myreseller")));
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCreate");
    }

    public void domainUpdate() {
        this.printStart("domainUpdate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainUpdate: Add reseller with EPPOrgExt extension");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.com");
            EPPOrgExtUpdate theExt = new EPPOrgExtUpdate();
            theExt.addAddOrg(new EPPOrgExtId("reseller", "myreseller"));
            this.domain.addExtension(theExt);
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainUpdate: Response = [" + response + "]\n\n");
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainUpdate: Remove reseller with EPPOrgExt extension");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.com");
            theExt = new EPPOrgExtUpdate();
            theExt.addRemOrg(new EPPOrgExtId("reseller", "myreseller"));
            this.domain.addExtension(theExt);
            response = this.domain.sendUpdate();
            System.out.println("domainUpdate: Response = [" + response + "]\n\n");
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainUpdate: Change reseller with EPPOrgExt extension");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.com");
            theExt = new EPPOrgExtUpdate();
            theExt.addChgOrg(new EPPOrgExtId("reseller", "myreseller"));
            this.domain.addExtension(theExt);
            response = this.domain.sendUpdate();
            System.out.println("domainUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCreate");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPOrgExtDomainTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPOrgExtDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPOrgExtDomainTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

