/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokedVerificationCode
implements Serializable,
Cloneable {
    private static Logger cat = LoggerFactory.getLogger(RevokedVerificationCode.class);
    private String code;
    private Date revokedDate;

    public RevokedVerificationCode() {
    }

    public RevokedVerificationCode(String aCode, Date aRevokedDate) {
        this.code = aCode;
        this.revokedDate = aRevokedDate;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public Date getRevokedDate() {
        return this.revokedDate;
    }

    public void setRevokedDate(Date aRevokedDate) {
        this.revokedDate = aRevokedDate;
    }

    public String encode() throws EPPEncodeException {
        cat.debug("encode(): enter");
        if (this.code == null) {
            throw new EPPEncodeException("encode(): code required attribute is null.");
        }
        if (this.revokedDate == null) {
            throw new EPPEncodeException("encode(): revokedDate required attribute is null.");
        }
        String ret = this.code + "," + EPPUtil.encodeTimeInstant(this.revokedDate);
        cat.debug("encode(): Encoded value = \"" + ret + "\"");
        cat.debug("encode(): exit");
        return ret;
    }

    public void decode(String aLine) throws EPPDecodeException {
        cat.debug("decode(String): enter");
        int sepIndex = aLine.indexOf(44);
        if (sepIndex == -1) {
            throw new EPPDecodeException("decode(): , seperator not found in revoked verification code line");
        }
        this.code = aLine.substring(0, sepIndex);
        String revokedDateStr = aLine.substring(sepIndex + 1);
        this.revokedDate = EPPUtil.decodeTimeInstant(revokedDateStr);
        if (this.revokedDate == null) {
            throw new EPPDecodeException("decode(): Error decoding the revoked date");
        }
        cat.debug("decode(String): exit");
    }

    public Object clone() throws CloneNotSupportedException {
        RevokedVerificationCode clone = (RevokedVerificationCode)super.clone();
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof RevokedVerificationCode)) {
            cat.error("RevokedVerificationCode.equals(): aObject is not an RevokedVerificationCode");
            return false;
        }
        RevokedVerificationCode other = (RevokedVerificationCode)aObject;
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error("RevokedVerificationCode.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.revokedDate, other.revokedDate)) {
            cat.error("RevokedVerificationCode.equals(): revokedDate not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            return this.encode();
        }
        catch (EPPEncodeException e) {
            throw new RuntimeException(e);
        }
    }
}

