/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckResult;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPValidateCheckResp
extends EPPResponse {
    public static final String ELM_LOCALNAME = "chkData";
    static final String ELM_NAME = "validate:chkData";
    private static Logger cat = LoggerFactory.getLogger(EPPValidateCheckResp.class);
    private List<EPPValidateCheckResult> results = new ArrayList<EPPValidateCheckResult>();

    public EPPValidateCheckResp() {
    }

    public EPPValidateCheckResp(EPPTransId aTransId) {
        super(aTransId);
    }

    public EPPValidateCheckResp(EPPTransId aTransId, EPPValidateCheckResult aResult) {
        super(aTransId);
        this.results.add(aResult);
    }

    public EPPValidateCheckResp(EPPTransId aTransId, List<EPPValidateCheckResult> aResults) {
        super(aTransId);
        this.results = aResults;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:validate-0.2";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPValidateCheckResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPValidateCheckResp other = (EPPValidateCheckResp)aObject;
        if (!EqualityUtil.equals(this.results, other.results)) {
            cat.error("EPPValidateCheckResp.equals(): results not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPValidateCheckResp clone = (EPPValidateCheckResp)super.clone();
        clone.results = new ArrayList<EPPValidateCheckResult>(this.results.size());
        for (EPPValidateCheckResult item : this.results) {
            clone.results.add((EPPValidateCheckResult)item.clone());
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public void addResult(EPPValidateCheckResult aResult) {
        this.results.add(aResult);
    }

    public void setCheckResults(List<EPPValidateCheckResult> aResults) {
        this.results = aResults == null ? new ArrayList<EPPValidateCheckResult>() : aResults;
    }

    public List<EPPValidateCheckResult> getCheckResults() {
        return this.results;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:validate-0.2", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.results);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.results = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:validate-0.2", "validate:cd", EPPValidateCheckResult.class);
    }
}

