/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgpext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPRgpExtStatus
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRgpExtStatus.class);
    public static final String ADD_PERIOD = "addPeriod";
    public static final String AUTO_RENEW_PERIOD = "autoRenewPeriod";
    public static final String RENEW_PERIOD = "renewPeriod";
    public static final String TRANSFER_PERIOD = "transferPeriod";
    public static final String PENDING_DELETE = "pendingDelete";
    public static final String PENDING_RESTORE = "pendingRestore";
    public static final String REDEMPTION_PERIOD = "redemptionPeriod";
    public static final String ELM_DEFAULT_LANG = "en";
    static final String ELM_LANG = "lang";
    static final String ELM_NAME = "rgp:rgpStatus";
    static final String ELM_STATUS = "s";
    private String message = null;
    private String status = "addPeriod";
    private String lang = "en";

    public EPPRgpExtStatus() {
    }

    public EPPRgpExtStatus(String aStatus) {
        this.status = aStatus;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRgpExtStatus.doEncode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPRgpExtStatus invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:rgp-1.0", ELM_NAME);
        root.setAttribute(ELM_STATUS, this.status);
        if (this.message != null) {
            if (!this.lang.equals(ELM_DEFAULT_LANG)) {
                root.setAttribute(ELM_LANG, this.lang);
            }
            Text descVal = aDocument.createTextNode(this.message);
            root.appendChild(descVal);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.status = aElement.getAttribute(ELM_STATUS);
        Node msgNode = aElement.getFirstChild();
        if (msgNode != null) {
            this.message = msgNode.getNodeValue();
            this.lang = aElement.getAttribute(ELM_LANG);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRgpExtStatus)) {
            return false;
        }
        EPPRgpExtStatus theComp = (EPPRgpExtStatus)aObject;
        if (!(this.status != null ? this.status.equals(theComp.status) : theComp.status == null)) {
            return false;
        }
        if (!(this.message != null ? this.message.equals(theComp.message) : theComp.message == null)) {
            return false;
        }
        return this.lang != null ? this.lang.equals(theComp.lang) : theComp.lang == null;
    }

    void validateState() throws EPPCodecException {
        if (this.status == null) {
            throw new EPPCodecException("EPPRgpExtStatus required attribute is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRgpExtStatus clone = null;
        clone = (EPPRgpExtStatus)super.clone();
        clone.message = this.message;
        clone.lang = this.lang;
        clone.status = this.status;
        return clone;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:rgp-1.0";
    }
}

