/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryRegex
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryRegex.class);
    public static final String ELM_EXPRESSION = "expression";
    public static final String ELM_DESCRIPTION = "description";
    public static final String ATTR_LANG = "lang";
    private String rootName = null;
    private String expression = null;
    private String description = null;
    private String lang = null;

    public EPPRegistryRegex() {
    }

    public EPPRegistryRegex(String aExpression) {
        this();
        this.expression = aExpression;
    }

    public EPPRegistryRegex(String aExpression, String aDescription) {
        this(aExpression);
        this.description = aDescription;
    }

    public EPPRegistryRegex(String aExpression, String aDescription, String aLang) {
        this(aExpression);
        this.description = aDescription;
        this.lang = aLang;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.rootName == null || this.rootName.trim().length() == 0) {
            throw new EPPEncodeException("rootName is not set");
        }
        if (this.expression == null || this.expression.trim().length() == 0) {
            throw new EPPEncodeException("expression attribute is not set in EPPRegistryRegex.encode");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", "registry:" + this.getRootName());
        EPPUtil.encodeString(aDocument, root, this.expression, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:expression");
        if (this.description != null && this.description.trim().length() > 0) {
            if (this.lang == null || this.lang.trim().length() == 0) {
                this.lang = "en";
            }
            Element currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", "registry:description");
            Text currVal = aDocument.createTextNode(this.description);
            currElm.setAttribute(ATTR_LANG, this.lang);
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.rootName = aElement.getLocalName();
        this.expression = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_EXPRESSION);
        this.description = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_DESCRIPTION);
        if (this.description != null) {
            Element theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_DESCRIPTION);
            this.lang = theElm.getAttribute(ATTR_LANG);
            if (this.lang == null || this.lang.trim().length() == 0) {
                this.lang = "en";
            }
        }
        if (this.expression == null || this.expression.trim().length() == 0) {
            throw new EPPDecodeException("expression attribute is not set in EPPRegistryRegex.decode");
        }
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryRegex)super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryRegex)) {
            return false;
        }
        EPPRegistryRegex theComp = (EPPRegistryRegex)aObject;
        if (!(this.rootName != null ? this.rootName.equals(theComp.rootName) : theComp.rootName == null)) {
            return false;
        }
        if (!EqualityUtil.equals(this.expression, theComp.expression)) {
            cat.error("EPPRegistryRegex.equals(): expression not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.description, theComp.description)) {
            cat.error("EPPRegistryRegex.equals(): description not equal");
            return false;
        }
        if (this.description != null && !EqualityUtil.equals(this.lang, theComp.lang)) {
            cat.error("EPPRegistryRegex.equals(): lang not equal");
            return false;
        }
        return true;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String aExpression) {
        this.expression = aExpression;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    String getRootName() {
        return this.rootName;
    }

    void setRootName(String aRootName) {
        int namespaceSepIndex;
        if (aRootName != null && (namespaceSepIndex = aRootName.indexOf(58)) != -1 && aRootName.length() > namespaceSepIndex) {
            aRootName = aRootName.substring(namespaceSepIndex + 1);
        }
        this.rootName = aRootName;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

