/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryAbstractMinMax;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryKey
extends EPPRegistryAbstractMinMax {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryKey.class);
    public static final String ELM_LOCALNAME = "keyDataInterface";
    public static final String ELM_NAME = "registry:keyDataInterface";
    public static final String ELM_FLAGS = "flags";
    public static final String ELM_PROTOCOL = "protocol";
    public static final String ELM_ALGORITHM = "alg";
    private List<Integer> flags = new ArrayList<Integer>();
    private List<Integer> protocols = new ArrayList<Integer>();
    private List<Integer> algorithms = new ArrayList<Integer>();

    public EPPRegistryKey() {
    }

    public EPPRegistryKey(Integer aMin, Integer aMax) {
        super(aMin, aMax);
    }

    public EPPRegistryKey(Integer aMin, Integer aMax, List<Integer> aFlags, List<Integer> aProtocols, List<Integer> aAlgorithms) {
        super(aMin, aMax);
        this.setFlags(aFlags);
        this.setProtocols(aProtocols);
        this.setAlgorithms(aAlgorithms);
    }

    public EPPRegistryKey(int aMin, int aMax, List<Integer> aFlags, List<Integer> aProtocols, List<Integer> aAlgorithms) {
        super(aMin, aMax);
        this.setFlags(aFlags);
        this.setProtocols(aProtocols);
        this.setAlgorithms(aAlgorithms);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = super.encode(aDocument);
        EPPUtil.encodeIntegerList(aDocument, root, this.flags, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:flags");
        EPPUtil.encodeIntegerList(aDocument, root, this.protocols, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:protocol");
        EPPUtil.encodeIntegerList(aDocument, root, this.algorithms, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:alg");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.flags = EPPUtil.decodeIntegerList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_FLAGS);
        this.protocols = EPPUtil.decodeIntegerList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_PROTOCOL);
        this.algorithms = EPPUtil.decodeIntegerList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_ALGORITHM);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryKey clone = (EPPRegistryKey)super.clone();
        if (this.flags != null) {
            clone.flags = (List)((ArrayList)this.flags).clone();
        }
        if (this.protocols != null) {
            clone.protocols = (List)((ArrayList)this.protocols).clone();
        }
        if (this.algorithms != null) {
            clone.algorithms = (List)((ArrayList)this.algorithms).clone();
        }
        return clone;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(aObject instanceof EPPRegistryKey)) {
            return false;
        }
        EPPRegistryKey theComp = (EPPRegistryKey)aObject;
        if (!(this.flags != null ? EPPUtil.equalLists(this.flags, theComp.flags) : theComp.flags == null)) {
            cat.error("EPPRegistryKey.equals(): flags not equal");
            return false;
        }
        if (!(this.protocols != null ? EPPUtil.equalLists(this.protocols, theComp.protocols) : theComp.protocols == null)) {
            cat.error("EPPRegistryKey.equals(): protocols not equal");
            return false;
        }
        if (!(this.algorithms != null ? EPPUtil.equalLists(this.algorithms, theComp.algorithms) : theComp.algorithms == null)) {
            cat.error("EPPRegistryKey.equals(): algorithms not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasFlags() {
        return this.flags != null && !this.flags.isEmpty();
    }

    public List<Integer> getFlags() {
        return this.flags;
    }

    public void setFlags(List<Integer> aFlags) {
        this.flags = aFlags == null ? new ArrayList<Integer>() : aFlags;
    }

    public void addFlags(Integer aFlags) {
        if (this.flags == null) {
            this.flags = new ArrayList<Integer>();
        }
        this.flags.add(aFlags);
    }

    public boolean hasProtocols() {
        return this.protocols != null && !this.protocols.isEmpty();
    }

    public List<Integer> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<Integer> aProtocol) {
        this.protocols = aProtocol == null ? new ArrayList<Integer>() : aProtocol;
    }

    public void addProtocol(Integer aProtocol) {
        if (this.protocols == null) {
            this.protocols = new ArrayList<Integer>();
        }
        this.protocols.add(aProtocol);
    }

    public boolean hasAlgorithms() {
        return this.algorithms != null && !this.algorithms.isEmpty();
    }

    public List<Integer> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(List<Integer> aAlgorithms) {
        this.algorithms = aAlgorithms == null ? new ArrayList<Integer>() : aAlgorithms;
    }

    public void addAlgorithm(Integer aAlgorithm) {
        if (this.algorithms == null) {
            this.algorithms = new ArrayList<Integer>();
        }
        this.algorithms.add(aAlgorithm);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    protected String getRootName() {
        return ELM_LOCALNAME;
    }

    @Override
    protected String getElmMin() {
        return "min";
    }

    @Override
    protected String getElmMax() {
        return "max";
    }

    @Override
    protected Logger getLogger() {
        return cat;
    }
}

