/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneName;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryInfoCmd
extends EPPInfoCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryInfoCmd.class);
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "registry:info";
    private static final String ELM_REGISTRY_ALL = "all";
    private static final String ELM_REGISTRY_SYSTEM = "system";
    public static final String ATTR_SCOPE = "scope";
    private Mode mode = null;
    private Scope scope = Scope.accessible;
    private EPPRegistryZoneName name = null;

    public EPPRegistryInfoCmd() {
    }

    public EPPRegistryInfoCmd(String aTransId, String aName) {
        super(aTransId);
        this.setName(aName);
    }

    public EPPRegistryInfoCmd(String aTransId, EPPRegistryZoneName aName) {
        super(aTransId);
        this.setName(aName);
    }

    public EPPRegistryInfoCmd(String aTransId, Mode aMode) {
        super(aTransId);
        this.setMode(aMode);
    }

    public EPPRegistryInfoCmd(String aTransId, Scope aScope) {
        super(aTransId);
        this.setScope(aScope);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (!this.hasMode()) {
            throw new EPPEncodeException("The mode must be set");
        }
        if (this.getMode() == Mode.name && !this.hasName()) {
            throw new EPPEncodeException("The zone name must be set when the mode is \"name\"");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        switch (this.mode) {
            case name: {
                EPPUtil.encodeComp(aDocument, root, this.name);
                break;
            }
            case all: {
                Element theAllElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", "registry:all");
                root.appendChild(theAllElm);
                theAllElm.setAttribute(ATTR_SCOPE, this.scope.toString());
                break;
            }
            case system: {
                root.appendChild(aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", "registry:system"));
            }
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theModeElm = EPPUtil.getFirstElementChild(aElement);
        this.mode = Mode.valueOf(theModeElm.getLocalName());
        switch (this.mode) {
            case name: {
                this.name = (EPPRegistryZoneName)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "name", EPPRegistryZoneName.class);
                this.scope = Scope.accessible;
                break;
            }
            case all: {
                String theScopeStr = EPPUtil.decodeStringAttr(theModeElm, ATTR_SCOPE);
                this.scope = theScopeStr == null ? Scope.accessible : Scope.valueOf(theScopeStr);
                this.name = null;
                break;
            }
            case system: {
                this.name = null;
                this.scope = Scope.accessible;
            }
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryInfoCmd)) {
            cat.error("EPPRegistryInfoCmd.equals(): " + aObject.getClass().getName() + " not EPPRegistryInfoCmd instance");
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error("EPPRegistryInfoCmd.equals(): super class not equal");
            return false;
        }
        EPPRegistryInfoCmd theComp = (EPPRegistryInfoCmd)aObject;
        if (!EqualityUtil.equals((Object)this.mode, (Object)theComp.mode)) {
            cat.error("EPPRegistryInfoCmd.equals(): mode not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error("EPPRegistryInfoCmd.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.scope, (Object)theComp.scope)) {
            cat.error("EPPRegistryInfoCmd.equals(): scope not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryInfoCmd clone = (EPPRegistryInfoCmd)super.clone();
        if (this.name != null) {
            clone.name = (EPPRegistryZoneName)this.name.clone();
        }
        return clone;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public EPPRegistryZoneName getName() {
        return this.name;
    }

    public void setName(EPPRegistryZoneName aName) {
        this.name = aName;
        this.mode = Mode.name;
    }

    public void setName(String aName) {
        this.setName(new EPPRegistryZoneName(aName, EPPRegistryZoneName.Form.aLabel));
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode aMode) {
        this.mode = aMode;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope aScope) {
        this.scope = aScope == null ? Scope.accessible : aScope;
        this.mode = Mode.all;
    }

    public static enum Scope {
        accessible,
        available,
        both;

    }

    public static enum Mode {
        all,
        name,
        system;

    }
}

