/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryMinMaxPeriod;
import com.verisign.epp.codec.registry.v02.EPPRegistryPeriodType;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDomainPeriod
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryDomainPeriod.class);
    public static final String ELM_LOCALNAME = "period";
    public static final String ELM_NAME = "registry:period";
    public static final String ELM_SERVER_DECIDED = "serverDecided";
    public static final String ATTR_COMMAND = "command";
    public static final int MAX_PERIOD = 99;
    public static final int MIN_PERIOD = 1;
    private EPPRegistryMinMaxPeriod length = null;
    private Boolean serverDecided = Boolean.FALSE;
    private String command = null;

    public EPPRegistryDomainPeriod() {
    }

    public EPPRegistryDomainPeriod(String aCommand, Integer aMin, EPPRegistryPeriodType.Unit aMinUnit, Integer aMax, EPPRegistryPeriodType.Unit aMaxUnit, Integer aDefaultLength, EPPRegistryPeriodType.Unit aDefaultLengthUnit) {
        this.command = aCommand;
        this.length = new EPPRegistryMinMaxPeriod(aMin, aMinUnit, aMax, aMaxUnit, aDefaultLength, aDefaultLengthUnit);
    }

    public EPPRegistryDomainPeriod(String aCommand, int aMin, EPPRegistryPeriodType.Unit aMinUnit, int aMax, EPPRegistryPeriodType.Unit aMaxUnit, int aDefaultLength, EPPRegistryPeriodType.Unit aDefaultLengthUnit) {
        this.command = aCommand;
        this.length = new EPPRegistryMinMaxPeriod(aMin, aMinUnit, aMax, aMaxUnit, aDefaultLength, aDefaultLengthUnit);
    }

    public EPPRegistryDomainPeriod(String aCommand, Boolean aServerDecided) {
        this.command = aCommand;
        this.serverDecided = aServerDecided;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryDomainPeriod.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        root.setAttribute(ATTR_COMMAND, this.command);
        if (this.length != null) {
            EPPUtil.encodeComp(aDocument, root, this.length);
        }
        if (this.serverDecided.booleanValue()) {
            Element child = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", "registry:serverDecided");
            root.appendChild(child);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.command = aElement.getAttribute(ATTR_COMMAND);
        Element child = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_SERVER_DECIDED);
        Boolean bl = this.serverDecided = child == null ? Boolean.FALSE : Boolean.TRUE;
        if (Boolean.FALSE == this.serverDecided) {
            this.setLength((EPPRegistryMinMaxPeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:length", EPPRegistryMinMaxPeriod.class));
        }
    }

    void validateState() throws EPPCodecException {
        if (this.length == null && !this.serverDecided.booleanValue() || this.length != null && this.serverDecided.booleanValue()) {
            throw new EPPCodecException("Either specify length or make it server decided");
        }
        if (this.command == null || this.command.trim().length() == 0) {
            throw new EPPEncodeException("command is required");
        }
        if (this.length != null) {
            this.validPeriod(this.length.getMin(), "min");
            this.validPeriod(this.length.getMax(), "max");
            this.validPeriod(this.length.getDefaultLength(), "default");
            if (this.comparePeriod(this.length.getMin(), this.length.getDefaultLength()) > 0) {
                throw new EPPCodecException("min period cannot be greater than default period");
            }
            if (this.comparePeriod(this.length.getDefaultLength(), this.length.getMax()) > 0) {
                throw new EPPCodecException("default period cannot be greater than max period");
            }
        }
    }

    private void validPeriod(EPPRegistryPeriodType aPeriod, String aType) throws EPPCodecException {
        if (aPeriod == null) {
            throw new EPPCodecException(aType + " period is required");
        }
        aPeriod.validateState();
    }

    private int comparePeriod(EPPRegistryPeriodType aLeft, EPPRegistryPeriodType aRight) {
        int l = 0;
        int r = 0;
        if ("y".equals((Object)aLeft.getUnit())) {
            l = aLeft.getNumber() * 12;
        } else if ("m".equals((Object)aLeft.getUnit())) {
            l = aLeft.getNumber();
        }
        if ("y".equals((Object)aRight.getUnit())) {
            r = aRight.getNumber() * 12;
        } else if ("m".equals((Object)aRight.getUnit())) {
            r = aRight.getNumber();
        }
        return l - r;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDomainPeriod clone = (EPPRegistryDomainPeriod)super.clone();
        if (this.length != null) {
            clone.length = (EPPRegistryMinMaxPeriod)this.length.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDomainPeriod)) {
            return false;
        }
        EPPRegistryDomainPeriod theComp = (EPPRegistryDomainPeriod)aObject;
        if (!EqualityUtil.equals(this.length, theComp.length)) {
            cat.error("EPPRegistryDomainPeriod.equals(): length not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.serverDecided, theComp.serverDecided)) {
            cat.error("EPPRegistryDomainPeriod.equals(): serverDecided not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.command, theComp.command)) {
            cat.error("EPPRegistryDomainPeriod.equals(): command not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryMinMaxPeriod getLength() {
        return this.length;
    }

    public void setLength(EPPRegistryMinMaxPeriod length) {
        this.length = length;
    }

    public Boolean getServerDecided() {
        return this.serverDecided;
    }

    public void setServerDecided(Boolean serverDecided) {
        this.serverDecided = serverDecided;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

