/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.v02.EPPRegistryExceedMaxExDate;
import com.verisign.epp.codec.registry.v02.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.v02.EPPRegistryIDN;
import com.verisign.epp.codec.registry.v02.EPPRegistryRGP;
import com.verisign.epp.codec.registry.v02.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v02.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.v02.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDomain
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryDomain.class);
    public static final String ELM_LOCALNAME = "domain";
    public static final String ELM_NAME = "registry:domain";
    public static final String ELM_PREMIUM_SUPPORT = "premiumSupport";
    public static final String ELM_REGISTRANT = "contactsSupported";
    public static final String ELM_EXCEED_MAX_EX_DATE = "exceedMaxExDate";
    public static final String ELM_MAX_CHECK_DOMAIN = "maxCheckDomain";
    public static final String ELM_AUTH_INFO_REGEX = "authInfoRegex";
    public static final String ELM_NULL_AUTH_INFO_SUPPORTED = "nullAuthInfoSupported";
    public static final String ELM_HOST_MODEL_SUPPORTED = "hostModelSupported";
    private List<EPPRegistryDomainName> domainNames = new ArrayList<EPPRegistryDomainName>();
    private EPPRegistryIDN idn = null;
    private Boolean premiumSupport = Boolean.FALSE;
    private Boolean contactsSupported = Boolean.TRUE;
    private List<EPPRegistryDomainContact> contacts = new ArrayList<EPPRegistryDomainContact>();
    private EPPRegistryDomainNSLimit nameServerLimit = null;
    private EPPRegistryDomainHostLimit childHostLimit = null;
    private List<EPPRegistryDomainPeriod> periods = new ArrayList<EPPRegistryDomainPeriod>();
    private List<EPPRegistryExceedMaxExDate> exceedMaxExDates = new ArrayList<EPPRegistryExceedMaxExDate>();
    private EPPRegistryTransferHoldPeriodType transferHoldPeriod = null;
    private List<EPPRegistryGracePeriod> gracePeriods = new ArrayList<EPPRegistryGracePeriod>();
    private EPPRegistryRGP rgp = null;
    private EPPRegistryDNSSEC dnssec = null;
    private Integer maxCheckDomain = null;
    private EPPRegistrySupportedStatus supportedStatus = null;
    private EPPRegistryRegex authInfoRegex = null;
    private Boolean nullAuthInfoSupported = Boolean.FALSE;
    private HostModelSupported hostModelSupported = HostModelSupported.hostObj;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryDomain.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.domainNames);
        EPPUtil.encodeComp(aDocument, root, this.idn);
        if (!this.hasPremiumSupport()) {
            this.premiumSupport = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.premiumSupport.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:premiumSupport");
        if (!this.hasContactsSupported()) {
            this.contactsSupported = Boolean.TRUE;
        }
        EPPUtil.encodeString(aDocument, root, this.contactsSupported.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:contactsSupported");
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        EPPUtil.encodeComp(aDocument, root, this.nameServerLimit);
        EPPUtil.encodeComp(aDocument, root, this.childHostLimit);
        EPPUtil.encodeCompList(aDocument, root, this.periods);
        EPPUtil.encodeCompList(aDocument, root, this.exceedMaxExDates);
        EPPUtil.encodeComp(aDocument, root, this.transferHoldPeriod);
        EPPUtil.encodeCompList(aDocument, root, this.gracePeriods);
        if (this.rgp != null) {
            EPPUtil.encodeComp(aDocument, root, this.rgp);
        }
        if (this.dnssec != null) {
            EPPUtil.encodeComp(aDocument, root, this.dnssec);
        }
        EPPUtil.encodeString(aDocument, root, this.maxCheckDomain.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:maxCheckDomain");
        if (this.supportedStatus != null) {
            EPPUtil.encodeComp(aDocument, root, this.supportedStatus);
        }
        if (this.authInfoRegex != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfoRegex);
        }
        if (!this.hasNullAuthInfoSupported()) {
            this.nullAuthInfoSupported = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.nullAuthInfoSupported.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:nullAuthInfoSupported");
        EPPUtil.encodeString(aDocument, root, this.hostModelSupported.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:hostModelSupported");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theHostModelSupportedStr;
        this.domainNames = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:domainName", EPPRegistryDomainName.class);
        this.idn = (EPPRegistryIDN)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:idn", EPPRegistryIDN.class);
        this.premiumSupport = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_PREMIUM_SUPPORT);
        if (this.premiumSupport == null) {
            this.premiumSupport = Boolean.FALSE;
        }
        this.contactsSupported = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_REGISTRANT);
        if (this.contactsSupported == null) {
            this.contactsSupported = Boolean.TRUE;
        }
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:contact", EPPRegistryDomainContact.class);
        this.nameServerLimit = (EPPRegistryDomainNSLimit)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:ns", EPPRegistryDomainNSLimit.class);
        this.childHostLimit = (EPPRegistryDomainHostLimit)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:childHost", EPPRegistryDomainHostLimit.class);
        this.periods = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:period", EPPRegistryDomainPeriod.class);
        this.exceedMaxExDates = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:exceedMaxExDate", EPPRegistryExceedMaxExDate.class);
        this.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "transferHoldPeriod", EPPRegistryTransferHoldPeriodType.class);
        this.gracePeriods = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "gracePeriod", EPPRegistryGracePeriod.class);
        this.rgp = (EPPRegistryRGP)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:rgp", EPPRegistryRGP.class);
        this.dnssec = (EPPRegistryDNSSEC)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:dnssec", EPPRegistryDNSSEC.class);
        this.supportedStatus = (EPPRegistrySupportedStatus)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:supportedStatus", EPPRegistrySupportedStatus.class);
        this.maxCheckDomain = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_MAX_CHECK_DOMAIN);
        this.setAuthInfoRegex((EPPRegistryRegex)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_AUTH_INFO_REGEX, EPPRegistryRegex.class));
        this.nullAuthInfoSupported = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NULL_AUTH_INFO_SUPPORTED);
        if (this.nullAuthInfoSupported == null) {
            this.nullAuthInfoSupported = Boolean.FALSE;
        }
        this.hostModelSupported = (theHostModelSupportedStr = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_HOST_MODEL_SUPPORTED)) == null ? HostModelSupported.hostObj : HostModelSupported.valueOf(theHostModelSupportedStr);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDomain)) {
            return false;
        }
        EPPRegistryDomain theComp = (EPPRegistryDomain)aObject;
        if (!EqualityUtil.equals(this.domainNames, theComp.domainNames)) {
            cat.error("EPPRegistryDomain.equals(): domainNames not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.premiumSupport, theComp.premiumSupport)) {
            cat.error("EPPRegistryDomain.equals(): premiumSupport not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.idn, theComp.idn)) {
            cat.error("EPPRegistryDomain.equals(): idn not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contactsSupported, theComp.contactsSupported)) {
            cat.error("EPPRegistryDomain.equals(): contactsSupported not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contacts, theComp.contacts)) {
            cat.error("EPPRegistryDomain.equals(): contacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.nameServerLimit, theComp.nameServerLimit)) {
            cat.error("EPPRegistryDomain.equals(): nameServerLimit not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.childHostLimit, theComp.childHostLimit)) {
            cat.error("EPPRegistryDomain.equals(): childHostLimit not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.periods, theComp.periods)) {
            cat.error("EPPRegistryDomain.equals(): periods not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.exceedMaxExDates, theComp.exceedMaxExDates)) {
            cat.error("EPPRegistryDomain.equals(): exceedMaxExDates not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.transferHoldPeriod, theComp.transferHoldPeriod)) {
            cat.error("EPPRegistryDomain.equals(): transferHoldPeriod not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.gracePeriods, theComp.gracePeriods)) {
            cat.error("EPPRegistryDomain.equals(): gracePeriods not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.rgp, theComp.rgp)) {
            cat.error("EPPRegistryDomain.equals(): rgp not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.dnssec, theComp.dnssec)) {
            cat.error("EPPRegistryDomain.equals(): dnssec not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxCheckDomain, theComp.maxCheckDomain)) {
            cat.error("EPPRegistryDomain.equals(): maxCheckDomain not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.supportedStatus, theComp.supportedStatus)) {
            cat.error("EPPRegistryDomain.equals(): supportedStatus not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfoRegex, theComp.authInfoRegex)) {
            cat.error("EPPRegistryDomain.equals(): authInfoRegex not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.nullAuthInfoSupported, theComp.nullAuthInfoSupported)) {
            cat.error("EPPRegistryDomain.equals(): nullAuthInfoSupported not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.hostModelSupported, (Object)theComp.hostModelSupported)) {
            cat.error("EPPRegistryDomain.equals(): hostModelSupported not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.domainNames == null || this.domainNames.size() == 0) {
            throw new EPPCodecException("domainNames element is not set");
        }
        if (this.contacts != null && this.contacts.size() > 3) {
            throw new EPPCodecException("number of contact element cannot exceed 3");
        }
        if (this.nameServerLimit == null) {
            throw new EPPCodecException("ns element is not set");
        }
        if (this.transferHoldPeriod == null) {
            throw new EPPCodecException("transferHoldPeriod element is not set");
        }
        if (this.maxCheckDomain == null || this.maxCheckDomain <= 0) {
            throw new EPPCodecException("maxCheckDomain is required and should be greater than 0");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDomain clone = (EPPRegistryDomain)super.clone();
        if (this.domainNames != null) {
            clone.domainNames = (List)((ArrayList)this.domainNames).clone();
        }
        if (this.idn != null) {
            clone.idn = (EPPRegistryIDN)this.idn.clone();
        }
        if (this.contacts != null) {
            clone.contacts = (List)((ArrayList)this.contacts).clone();
        }
        if (this.nameServerLimit != null) {
            clone.nameServerLimit = (EPPRegistryDomainNSLimit)this.nameServerLimit.clone();
        }
        if (this.childHostLimit != null) {
            clone.childHostLimit = (EPPRegistryDomainHostLimit)this.childHostLimit.clone();
        }
        if (this.periods != null) {
            clone.periods = (List)((ArrayList)this.periods).clone();
        }
        if (this.exceedMaxExDates != null) {
            clone.exceedMaxExDates = (List)((ArrayList)this.exceedMaxExDates).clone();
        }
        if (this.transferHoldPeriod != null) {
            clone.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)this.transferHoldPeriod.clone();
        }
        if (this.gracePeriods != null) {
            clone.gracePeriods = (List)((ArrayList)this.gracePeriods).clone();
        }
        if (this.rgp != null) {
            clone.rgp = (EPPRegistryRGP)this.rgp.clone();
        }
        if (this.dnssec != null) {
            clone.dnssec = (EPPRegistryDNSSEC)this.dnssec.clone();
        }
        if (this.supportedStatus != null) {
            clone.supportedStatus = (EPPRegistrySupportedStatus)this.supportedStatus.clone();
        }
        if (this.authInfoRegex != null) {
            clone.authInfoRegex = (EPPRegistryRegex)this.authInfoRegex.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasDomainNames() {
        return this.domainNames != null && !this.domainNames.isEmpty();
    }

    public List<EPPRegistryDomainName> getDomainNames() {
        return this.domainNames;
    }

    public void setDomainNames(List<EPPRegistryDomainName> aDomainNames) {
        this.domainNames = aDomainNames == null ? new ArrayList<EPPRegistryDomainName>() : aDomainNames;
    }

    public void addDomainName(EPPRegistryDomainName aDomainName) {
        if (aDomainName == null) {
            return;
        }
        if (this.domainNames == null) {
            this.domainNames = new ArrayList<EPPRegistryDomainName>();
        }
        this.domainNames.add(aDomainName);
    }

    public EPPRegistryIDN getIdn() {
        return this.idn;
    }

    public void setIdn(EPPRegistryIDN idn) {
        this.idn = idn;
    }

    public boolean hasPremiumSupport() {
        return this.premiumSupport != null;
    }

    public Boolean getPremiumSupport() {
        return this.premiumSupport;
    }

    public void setPremiumSupport(Boolean aPremiumSupport) {
        this.premiumSupport = aPremiumSupport;
    }

    public boolean hasContactsSupported() {
        return this.contactsSupported != null;
    }

    public Boolean getContactsSupported() {
        return this.contactsSupported;
    }

    public void setContactsSupported(Boolean aContactsSupported) {
        this.contactsSupported = aContactsSupported;
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public List<EPPRegistryDomainContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPRegistryDomainContact> aContacts) {
        this.contacts = aContacts == null ? new ArrayList<EPPRegistryDomainContact>() : aContacts;
    }

    public void addContact(EPPRegistryDomainContact aContact) {
        if (aContact == null) {
            return;
        }
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPRegistryDomainContact>();
        }
        this.contacts.add(aContact);
    }

    public EPPRegistryDomainNSLimit getNameServerLimit() {
        return this.nameServerLimit;
    }

    public void setNameServerLimit(EPPRegistryDomainNSLimit nameServerLimit) {
        this.nameServerLimit = nameServerLimit;
    }

    public EPPRegistryDomainHostLimit getChildHostLimit() {
        return this.childHostLimit;
    }

    public void setChildHostLimit(EPPRegistryDomainHostLimit childHostLimit) {
        this.childHostLimit = childHostLimit;
    }

    public boolean hasPeriods() {
        return this.periods != null && !this.periods.isEmpty();
    }

    public List<EPPRegistryDomainPeriod> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<EPPRegistryDomainPeriod> aPeriods) {
        this.periods = aPeriods == null ? new ArrayList<EPPRegistryDomainPeriod>() : aPeriods;
    }

    public void addPeriod(EPPRegistryDomainPeriod aPeriod) {
        if (aPeriod == null) {
            return;
        }
        if (this.periods == null) {
            this.periods = new ArrayList<EPPRegistryDomainPeriod>();
        }
        this.periods.add(aPeriod);
    }

    public boolean hasExceedMaxExDates() {
        return this.exceedMaxExDates != null && !this.exceedMaxExDates.isEmpty();
    }

    public List<EPPRegistryExceedMaxExDate> getExceedMaxExDates() {
        return this.exceedMaxExDates;
    }

    public void setExceedMaxExDates(List<EPPRegistryExceedMaxExDate> aExceedMaxExDates) {
        this.exceedMaxExDates = aExceedMaxExDates == null ? new ArrayList<EPPRegistryExceedMaxExDate>() : aExceedMaxExDates;
    }

    public void addExceedMaxExDate(EPPRegistryExceedMaxExDate aExceedMaxExDate) {
        if (aExceedMaxExDate == null) {
            return;
        }
        if (this.exceedMaxExDates == null) {
            this.exceedMaxExDates = new ArrayList<EPPRegistryExceedMaxExDate>();
        }
        this.exceedMaxExDates.add(aExceedMaxExDate);
    }

    public EPPRegistryTransferHoldPeriodType getTransferHoldPeriod() {
        return this.transferHoldPeriod;
    }

    public void setTransferHoldPeriod(EPPRegistryTransferHoldPeriodType transferHoldPeriod) {
        this.transferHoldPeriod = transferHoldPeriod;
    }

    public boolean hasGracePeriods() {
        return this.gracePeriods != null && !this.gracePeriods.isEmpty();
    }

    public void addGracePeriod(EPPRegistryGracePeriod aGracePeriod) {
        if (aGracePeriod == null) {
            return;
        }
        if (this.gracePeriods == null) {
            this.gracePeriods = new ArrayList<EPPRegistryGracePeriod>();
        }
        this.gracePeriods.add(aGracePeriod);
    }

    public List<EPPRegistryGracePeriod> getGracePeriods() {
        return this.gracePeriods;
    }

    public void setGracePeriods(List<EPPRegistryGracePeriod> aGracePeriods) {
        this.gracePeriods = aGracePeriods == null ? new ArrayList<EPPRegistryGracePeriod>() : aGracePeriods;
    }

    public EPPRegistryRGP getRgp() {
        return this.rgp;
    }

    public void setRgp(EPPRegistryRGP rgp) {
        this.rgp = rgp;
    }

    public EPPRegistryDNSSEC getDnssec() {
        return this.dnssec;
    }

    public void setDnssec(EPPRegistryDNSSEC dnssec) {
        this.dnssec = dnssec;
    }

    public Integer getMaxCheckDomain() {
        return this.maxCheckDomain;
    }

    public void setMaxCheckDomain(Integer maxCheckDomain) {
        this.maxCheckDomain = maxCheckDomain;
    }

    public EPPRegistryRegex getAuthInfoRegex() {
        return this.authInfoRegex;
    }

    public void setAuthInfoRegex(EPPRegistryRegex authInfoRegex) {
        if (authInfoRegex != null) {
            authInfoRegex.setRootName(ELM_AUTH_INFO_REGEX);
        }
        this.authInfoRegex = authInfoRegex;
    }

    public boolean hasNullAuthInfoSupported() {
        return this.nullAuthInfoSupported != null;
    }

    public Boolean getNullAuthInfoSupported() {
        return this.nullAuthInfoSupported;
    }

    public void setNullAuthInfoSupported(Boolean aNullAuthInfoSupported) {
        this.nullAuthInfoSupported = aNullAuthInfoSupported;
    }

    public EPPRegistrySupportedStatus getSupportedStatus() {
        return this.supportedStatus;
    }

    public void setSupportedStatus(EPPRegistrySupportedStatus supportedStatus) {
        this.supportedStatus = supportedStatus;
    }

    public HostModelSupported getHostModelSupported() {
        return this.hostModelSupported;
    }

    public void setHostModelSupported(HostModelSupported aHostModelSupported) {
        this.hostModelSupported = aHostModelSupported == null ? HostModelSupported.hostObj : aHostModelSupported;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    public static enum HostModelSupported {
        hostObj,
        hostAttr;

    }
}

