/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryAbstractMinMax;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDS
extends EPPRegistryAbstractMinMax {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryDS.class);
    public static final String ELM_LOCALNAME = "dsDataInterface";
    public static final String ELM_NAME = "registry:dsDataInterface";
    public static final String ELM_ALGORITHM = "alg";
    public static final String ELM_DIGEST = "digestType";
    private List<Integer> algorithms = new ArrayList<Integer>();
    private List<Integer> digestTypes = new ArrayList<Integer>();

    public EPPRegistryDS() {
    }

    public EPPRegistryDS(Integer aMin, Integer aMax) {
        super(aMin, aMax);
    }

    public EPPRegistryDS(Integer aMin, Integer aMax, List<Integer> aAlgorithms, List<Integer> aDigestTypes) {
        super(aMin, aMax);
        this.setAlgorithms(aAlgorithms);
        this.setDigestTypes(aDigestTypes);
    }

    public EPPRegistryDS(int aMin, int aMax, List<Integer> aAlgorithms, List<Integer> aDigestTypes) {
        this((Integer)aMin, (Integer)aMax, aAlgorithms, aDigestTypes);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = super.encode(aDocument);
        EPPUtil.encodeIntegerList(aDocument, root, this.algorithms, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:alg");
        EPPUtil.encodeIntegerList(aDocument, root, this.digestTypes, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:digestType");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.algorithms = EPPUtil.decodeIntegerList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_ALGORITHM);
        this.digestTypes = EPPUtil.decodeIntegerList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_DIGEST);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDS clone = (EPPRegistryDS)super.clone();
        if (this.algorithms != null) {
            clone.algorithms = (List)((ArrayList)this.algorithms).clone();
        }
        if (this.digestTypes != null) {
            clone.digestTypes = (List)((ArrayList)this.digestTypes).clone();
        }
        return clone;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(aObject instanceof EPPRegistryDS)) {
            return false;
        }
        EPPRegistryDS theComp = (EPPRegistryDS)aObject;
        if (!(this.algorithms != null ? EPPUtil.equalLists(this.algorithms, theComp.algorithms) : theComp.algorithms == null)) {
            cat.error("EPPRegistryDS.equals(): algorithms not equal");
            return false;
        }
        if (!(this.digestTypes != null ? EPPUtil.equalLists(this.digestTypes, theComp.digestTypes) : theComp.digestTypes == null)) {
            cat.error("EPPRegistryDS.equals(): digestTypes not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasAlgorithms() {
        return this.algorithms != null && !this.algorithms.isEmpty();
    }

    public List<Integer> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(List<Integer> aAlgorithms) {
        this.algorithms = aAlgorithms == null ? new ArrayList<Integer>() : aAlgorithms;
    }

    public void addAlgorithm(Integer aAlgorithm) {
        if (this.algorithms == null) {
            this.algorithms = new ArrayList<Integer>();
        }
        this.algorithms.add(aAlgorithm);
    }

    public List<Integer> getDigestTypes() {
        return this.digestTypes;
    }

    public void setDigestTypes(List<Integer> aDigestTypes) {
        this.digestTypes = aDigestTypes == null ? new ArrayList<Integer>() : aDigestTypes;
    }

    public void addDigestType(Integer digestType) {
        if (this.digestTypes == null) {
            this.digestTypes = new ArrayList<Integer>();
        }
        this.digestTypes.add(digestType);
    }

    @Override
    protected String getRootName() {
        return ELM_LOCALNAME;
    }

    @Override
    protected String getElmMin() {
        return "min";
    }

    @Override
    protected String getElmMax() {
        return "max";
    }

    @Override
    protected Logger getLogger() {
        return cat;
    }
}

