/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryBatchSchedule;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryBatchJob
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryBatchJob.class);
    public static final String ELM_LOCALNAME = "batchJob";
    public static final String ELM_NAME = "registry:batchJob";
    static final String ELM_JOB_NAME = "name";
    static final String ELM_DESCRIPTION = "description";
    private String name = null;
    private String description = null;
    private List<EPPRegistryBatchSchedule> schedules = new ArrayList<EPPRegistryBatchSchedule>();

    public EPPRegistryBatchJob() {
    }

    public EPPRegistryBatchJob(String aName, String aDescription) {
        this.name = aName;
        this.description = aDescription;
    }

    public EPPRegistryBatchJob(String aName, EPPRegistryBatchSchedule aSchedule) {
        this.name = aName;
        this.addSchedule(aSchedule);
    }

    public EPPRegistryBatchJob(String aName, EPPRegistryBatchSchedule aSchedule, String aDescription) {
        this.name = aName;
        this.addSchedule(aSchedule);
        this.description = aDescription;
    }

    public EPPRegistryBatchJob(String aName, List<EPPRegistryBatchSchedule> aSchedules, String aDescription) {
        this.name = aName;
        this.setSchedules(aSchedules);
        this.description = aDescription;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("EPPRegistryBatchJob name is null");
        }
        if (!this.hasSchedules()) {
            throw new EPPEncodeException("EPPRegistryBatchJob schedules is empty");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:name");
        if (this.description != null) {
            EPPUtil.encodeString(aDocument, root, this.description, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:description");
        }
        EPPUtil.encodeCompList(aDocument, root, this.schedules);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_JOB_NAME);
        this.description = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_DESCRIPTION);
        this.schedules = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:schedule", EPPRegistryBatchSchedule.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryBatchJob)) {
            return false;
        }
        EPPRegistryBatchJob theComp = (EPPRegistryBatchJob)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error("EPPRegistryBatchJob.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.description, theComp.description)) {
            cat.error("EPPRegistryBatchJob.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.schedules, theComp.schedules)) {
            cat.error("EPPRegistryBatchJob.equals(): schedules not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public boolean hasSchedules() {
        return this.schedules != null && !this.schedules.isEmpty();
    }

    public List<EPPRegistryBatchSchedule> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(List<EPPRegistryBatchSchedule> aSchedules) {
        this.schedules = aSchedules == null ? new ArrayList<EPPRegistryBatchSchedule>() : aSchedules;
    }

    public void addSchedule(EPPRegistryBatchSchedule aSchedule) {
        if (aSchedule == null) {
            return;
        }
        if (this.schedules == null) {
            this.schedules = new ArrayList<EPPRegistryBatchSchedule>();
        }
        this.schedules.add(aSchedule);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

