/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.org.EPPOrgCheckCmd;
import com.verisign.epp.codec.org.EPPOrgCheckResp;
import com.verisign.epp.codec.org.EPPOrgCreateCmd;
import com.verisign.epp.codec.org.EPPOrgCreateResp;
import com.verisign.epp.codec.org.EPPOrgDeleteCmd;
import com.verisign.epp.codec.org.EPPOrgInfoCmd;
import com.verisign.epp.codec.org.EPPOrgInfoResp;
import com.verisign.epp.codec.org.EPPOrgPendActionMsg;
import com.verisign.epp.codec.org.EPPOrgUpdateCmd;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPOrgMapFactory
extends EPPMapFactory {
    public static final String NS = "urn:ietf:params:xml:ns:epp:org-1.0";
    public static final String NS_PREFIX = "org";
    private EPPService service = new EPPService("org", "urn:ietf:params:xml:ns:epp:org-1.0");

    public EPPOrgMapFactory() {
        this.service.setServiceType(0);
    }

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("org:check"))) {
            return new EPPOrgCheckCmd();
        }
        if (name.equals(EPPUtil.getLocalName("org:info"))) {
            return new EPPOrgInfoCmd();
        }
        if (name.equals(EPPUtil.getLocalName("org:create"))) {
            return new EPPOrgCreateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("org:delete"))) {
            return new EPPOrgDeleteCmd();
        }
        if (name.equals(EPPUtil.getLocalName("org:update"))) {
            return new EPPOrgUpdateCmd();
        }
        throw new EPPCodecException("Invalid command element " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("org:chkData"))) {
            return new EPPOrgCheckResp();
        }
        if (name.equals(EPPUtil.getLocalName("org:infData"))) {
            return new EPPOrgInfoResp();
        }
        if (name.equals(EPPUtil.getLocalName("org:creData"))) {
            return new EPPOrgCreateResp();
        }
        if (name.equals(EPPUtil.getLocalName("org:panData"))) {
            return new EPPOrgPendActionMsg();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    @Override
    public Set getXmlSchemas() {
        LinkedHashSet<String> theSchemas = new LinkedHashSet<String>();
        theSchemas.add("contact-1.0.xsd");
        theSchemas.add("org-1.0.xsd");
        return theSchemas;
    }
}

