/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.org.EPPOrgContact;
import com.verisign.epp.codec.org.EPPOrgPostalDefinition;
import com.verisign.epp.codec.org.EPPOrgRole;
import com.verisign.epp.codec.org.EPPOrgStatus;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPOrgInfoResp
extends EPPResponse {
    private static Logger cat = LoggerFactory.getLogger(EPPOrgInfoResp.class);
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "org:infData";
    private static final String ELM_ORG_ID = "id";
    private static final String ELM_ROID = "roid";
    private static final String ELM_STATUS = "status";
    private static final String ELM_PARENT_ID = "parentId";
    private static final String ELM_VOICE = "voice";
    private static final String ELM_FAX = "fax";
    private static final String ELM_EMAIL = "email";
    private static final String ELM_URL = "url";
    private static final String ELM_CLIENT_ID = "clID";
    private static final String ELM_CREATED_BY = "crID";
    private static final String ELM_CREATED_DATE = "crDate";
    private static final String ELM_LAST_UPDATED_BY = "upID";
    private static final String ELM_LAST_UPDATED_DATE = "upDate";
    private static final String ATTR_EXT = "x";
    private String orgId;
    private String roid;
    private List<EPPOrgRole> roles = new ArrayList<EPPOrgRole>();
    private List<EPPOrgStatus> statuses = new ArrayList<EPPOrgStatus>();
    private String parentId;
    private List<EPPOrgPostalDefinition> postalInfo = new ArrayList<EPPOrgPostalDefinition>();
    private String voice;
    private String voiceExt;
    private String fax;
    private String faxExt;
    private String email;
    private String url;
    private List<EPPOrgContact> contacts = new ArrayList<EPPOrgContact>();
    private String clientId;
    private String createdBy;
    private Date createdDate;
    private String lastUpdatedBy;
    private Date lastUpdatedDate;

    public EPPOrgInfoResp() {
    }

    public EPPOrgInfoResp(EPPTransId aTransId) {
        super(aTransId);
    }

    public EPPOrgInfoResp(EPPTransId aTransId, String aOrgId) {
        super(aTransId);
        this.orgId = aOrgId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String aOrgId) {
        this.orgId = aOrgId;
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    public boolean hasRole() {
        return !this.roles.isEmpty();
    }

    public List<EPPOrgRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<EPPOrgRole> aRoles) {
        this.roles = aRoles == null ? new ArrayList<EPPOrgRole>() : aRoles;
    }

    public void addRole(EPPOrgRole aRole) {
        this.roles.add(aRole);
    }

    public boolean hasStatus() {
        return !this.statuses.isEmpty();
    }

    public List<EPPOrgStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<EPPOrgStatus> aStatuses) {
        this.statuses = aStatuses == null ? new ArrayList<EPPOrgStatus>() : aStatuses;
    }

    public void addStatus(EPPOrgStatus aStatus) {
        this.statuses.add(aStatus);
    }

    public boolean hasParentId() {
        return this.parentId != null;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String aParentId) {
        this.parentId = aParentId;
    }

    public boolean hasPostalInfo() {
        return this.postalInfo != null && !this.postalInfo.isEmpty();
    }

    public void addPostalInfo(EPPOrgPostalDefinition aPostalInfo) {
        this.postalInfo.add(aPostalInfo);
    }

    public List<EPPOrgPostalDefinition> getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(List<EPPOrgPostalDefinition> aPostalInfo) {
        this.postalInfo = aPostalInfo;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public void addContact(EPPOrgContact aContact) {
        this.contacts.add(aContact);
    }

    public List<EPPOrgContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPOrgContact> aContacts) {
        this.contacts = aContacts;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String aClientId) {
        this.clientId = aClientId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String aCreatedBy) {
        this.createdBy = aCreatedBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aCreatedDate) {
        this.createdDate = aCreatedDate;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String aLastUpdatedBy) {
        this.lastUpdatedBy = aLastUpdatedBy;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date aLastUpdatedDate) {
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        Text theVal = null;
        if (this.orgId == null) {
            throw new EPPEncodeException("Undefined orgId in EPPOrgInfoResp");
        }
        if (this.roles.isEmpty()) {
            throw new EPPEncodeException("No roles set in EPPOrgInfoResp");
        }
        if (this.statuses.isEmpty()) {
            throw new EPPEncodeException("No statuses set in EPPOrgInfoResp");
        }
        if (this.clientId == null) {
            throw new EPPEncodeException("Undefined clientId in EPPOrgInfoResp");
        }
        if (this.createdBy == null) {
            throw new EPPEncodeException("Undefined createdBy in EPPOrgInfoResp");
        }
        if (this.createdDate == null) {
            throw new EPPEncodeException("Undefined createdDate in EPPOrgInfoResp");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.orgId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:id");
        EPPUtil.encodeString(aDocument, root, this.roid, "urn:ietf:params:xml:ns:epp:org-1.0", "org:roid");
        EPPUtil.encodeCompList(aDocument, root, this.roles);
        EPPUtil.encodeList(aDocument, root, this.statuses, "urn:ietf:params:xml:ns:epp:org-1.0", "org:status");
        EPPUtil.encodeString(aDocument, root, this.parentId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:parentId");
        EPPUtil.encodeCompList(aDocument, root, this.postalInfo);
        if (this.voice != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:voice");
            theVal = aDocument.createTextNode(this.voice);
            theElm.appendChild(theVal);
            if (this.voiceExt != null) {
                theElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            root.appendChild(theElm);
        }
        if (this.fax != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:fax");
            theVal = aDocument.createTextNode(this.fax);
            theElm.appendChild(theVal);
            if (this.faxExt != null) {
                theElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            root.appendChild(theElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:epp:org-1.0", "org:email");
        EPPUtil.encodeString(aDocument, root, this.url, "urn:ietf:params:xml:ns:epp:org-1.0", "org:url");
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        EPPUtil.encodeString(aDocument, root, this.clientId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:clID");
        EPPUtil.encodeString(aDocument, root, this.createdBy, "urn:ietf:params:xml:ns:epp:org-1.0", "org:crID");
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:epp:org-1.0", "org:crDate");
        EPPUtil.encodeString(aDocument, root, this.lastUpdatedBy, "urn:ietf:params:xml:ns:epp:org-1.0", "org:upID");
        EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:epp:org-1.0", "org:upDate");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theElm = null;
        this.orgId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_ORG_ID);
        this.roid = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_ROID);
        this.roles = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", "org:role", EPPOrgRole.class);
        this.statuses = EPPUtil.decodeEnumList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_STATUS, EPPOrgStatus.class);
        this.parentId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_PARENT_ID);
        this.postalInfo = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", "org:postalInfo", EPPOrgPostalDefinition.class);
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_VOICE);
        if (theElm != null) {
            this.voice = EPPUtil.getTextContent(theElm);
            this.voiceExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.voice = null;
            this.voiceExt = null;
        }
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_FAX);
        if (theElm != null) {
            this.fax = EPPUtil.getTextContent(theElm);
            this.faxExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.fax = null;
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_EMAIL);
        this.url = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_URL);
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", "org:contact", EPPOrgContact.class);
        this.clientId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_CLIENT_ID);
        this.createdBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_CREATED_BY);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_CREATED_DATE);
        this.lastUpdatedBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_LAST_UPDATED_BY);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_LAST_UPDATED_DATE);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgInfoResp clone = (EPPOrgInfoResp)super.clone();
        clone.roles = (List)((ArrayList)this.roles).clone();
        clone.statuses = (List)((ArrayList)this.statuses).clone();
        if (this.hasPostalInfo()) {
            clone.postalInfo = (List)((ArrayList)this.postalInfo).clone();
        }
        if (this.hasContacts()) {
            clone.contacts = (List)((ArrayList)this.contacts).clone();
        }
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgInfoResp)) {
            return false;
        }
        EPPOrgInfoResp other = (EPPOrgInfoResp)aObject;
        if (!EqualityUtil.equals(this.orgId, other.orgId)) {
            cat.error("EPPOrgInfoResp.equals(): orgId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.roid, other.roid)) {
            cat.error("EPPOrgInfoResp.equals(): roid not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.roles, other.roles)) {
            cat.error("EPPOrgInfoResp.equals(): roles not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.statuses, other.statuses)) {
            cat.error("EPPOrgInfoResp.equals(): statuses not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error("EPPOrgInfoResp.equals(): parentId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error("EPPOrgInfoResp.equals(): parentId not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.postalInfo, other.postalInfo)) {
            cat.error("EPPOrgInfoResp.equals(): postalInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, other.voice)) {
            cat.error("EPPOrgInfoResp.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, other.voiceExt)) {
            cat.error("EPPOrgInfoResp.equals(): voiceExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fax, other.fax)) {
            cat.error("EPPOrgInfoResp.equals(): fax not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, other.faxExt)) {
            cat.error("EPPOrgInfoResp.equals(): faxExt not equal, this.faxExt = " + this.faxExt + ", other.faxExt = " + other.faxExt);
            return false;
        }
        if (!EqualityUtil.equals(this.email, other.email)) {
            cat.error("EPPOrgInfoResp.equals(): email not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.url, other.url)) {
            cat.error("EPPOrgInfoResp.equals(): url not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.contacts, other.contacts)) {
            cat.error("EPPOrgInfoResp.equals(): contacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.clientId, other.clientId)) {
            cat.error("EPPOrgInfoResp.equals(): clientId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdBy, other.createdBy)) {
            cat.error("EPPOrgInfoResp.equals(): createdBy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdDate, other.createdDate)) {
            cat.error("EPPOrgInfoResp.equals(): createdDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedBy, other.lastUpdatedBy)) {
            cat.error("EPPOrgInfoResp.equals(): lastUpdatedBy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedDate, other.lastUpdatedDate)) {
            cat.error("EPPOrgInfoResp.equals(): lastUpdateDate not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

