/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateResp;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoResp;
import com.verisign.epp.codec.nv.EPPNameVerificationPendActionMsg;
import com.verisign.epp.codec.nv.EPPNameVerificationUpdateCmd;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPNameVerificationMapFactory
extends EPPMapFactory {
    public static final String NS = "urn:ietf:params:xml:ns:nv-1.0";
    public static final String NS_PREFIX = "nv";
    public static final String ELM_NV_AUTHINFO = "nv:authInfo";
    private EPPService service = new EPPService("nv", "urn:ietf:params:xml:ns:nv-1.0");

    public EPPNameVerificationMapFactory() {
        this.service.setServiceType(0);
    }

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("nv:check"))) {
            return new EPPNameVerificationCheckCmd();
        }
        if (name.equals(EPPUtil.getLocalName("nv:info"))) {
            return new EPPNameVerificationInfoCmd();
        }
        if (name.equals(EPPUtil.getLocalName("nv:create"))) {
            return new EPPNameVerificationCreateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("nv:update"))) {
            return new EPPNameVerificationUpdateCmd();
        }
        throw new EPPCodecException("Invalid command element " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("nv:chkData"))) {
            return new EPPNameVerificationCheckResp();
        }
        if (name.equals(EPPUtil.getLocalName("nv:infData"))) {
            return new EPPNameVerificationInfoResp();
        }
        if (name.equals(EPPUtil.getLocalName("nv:creData"))) {
            return new EPPNameVerificationCreateResp();
        }
        if (name.equals(EPPUtil.getLocalName("nv:panData"))) {
            return new EPPNameVerificationPendActionMsg();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    @Override
    public Set getXmlSchemas() {
        LinkedHashSet<String> theSchemas = new LinkedHashSet<String>();
        theSchemas.add("xmldsig-core-schema.xsd");
        theSchemas.add("verificationCode-1.0.xsd");
        theSchemas.add("nv-1.0.xsd");
        return theSchemas;
    }
}

