/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.mark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPMarkAddress
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPMarkAddress.class);
    public static final String ELM_LOCALNAME = "addr";
    public static final String ELM_NAME = "mark:addr";
    private static final String ELM_STREET = "street";
    private static final String ELM_CITY = "city";
    private static final String ELM_SP = "sp";
    private static final String ELM_PC = "pc";
    private static final String ELM_CC = "cc";
    List<String> streets = new ArrayList<String>();
    String city;
    String sp;
    String pc;
    String cc;

    public EPPMarkAddress() {
    }

    public EPPMarkAddress(List<String> aStreets, String aCity, String aSp, String aPc, String aCc) {
        this.setStreets(aStreets);
        this.city = aCity;
        this.sp = aSp;
        this.pc = aPc;
        this.cc = aCc;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMarkAddress clone = (EPPMarkAddress)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPMarkAddress.encode(Document)");
        }
        if (this.streets != null && this.streets.size() > 3) {
            throw new EPPEncodeException("street lines exceed the maximum of 3");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:mark-1.0", ELM_NAME);
        EPPUtil.encodeList(aDocument, root, this.streets, "urn:ietf:params:xml:ns:mark-1.0", "mark:street");
        EPPUtil.encodeString(aDocument, root, this.city, "urn:ietf:params:xml:ns:mark-1.0", "mark:city");
        EPPUtil.encodeString(aDocument, root, this.sp, "urn:ietf:params:xml:ns:mark-1.0", "mark:sp");
        EPPUtil.encodeString(aDocument, root, this.pc, "urn:ietf:params:xml:ns:mark-1.0", "mark:pc");
        EPPUtil.encodeString(aDocument, root, this.cc, "urn:ietf:params:xml:ns:mark-1.0", "mark:cc");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.streets = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_STREET);
        this.city = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_CITY);
        this.sp = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_SP);
        this.pc = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_PC);
        this.cc = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_CC);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMarkAddress)) {
            cat.error("EPPMarkAddress.equals(): aObject is not an EPPMarkAddress");
            return false;
        }
        EPPMarkAddress other = (EPPMarkAddress)aObject;
        if (!EqualityUtil.equals(this.streets, other.streets)) {
            cat.error("EPPMarkAddress.equals(): streets not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.city, other.city)) {
            cat.error("EPPMarkAddress.equals(): city not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.sp, other.sp)) {
            cat.error("EPPMarkAddress.equals(): sp not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.pc, other.pc)) {
            cat.error("EPPMarkAddress.equals(): pc not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.cc, other.cc)) {
            cat.error("EPPMarkAddress.equals(): cc not equal");
            return false;
        }
        return true;
    }

    public List<String> getStreets() {
        return this.streets;
    }

    public void setStreets(List<String> aStreets) {
        this.streets = aStreets == null ? new ArrayList<String>() : aStreets;
    }

    public void addStreet(String aStreet) {
        if (this.streets == null) {
            this.streets = new ArrayList<String>();
        }
        this.streets.add(aStreet);
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String aCity) {
        this.city = aCity;
    }

    public String getSp() {
        return this.sp;
    }

    public void setSp(String aSp) {
        this.sp = aSp;
    }

    public String getPc() {
        return this.pc;
    }

    public void setPc(String aPc) {
        this.pc = aPc;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String aCc) {
        this.cc = aCc;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:mark-1.0";
    }
}

