/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.idntable.EPPIdnTableDomainLabel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPIdnTableCheckCmd
extends EPPCheckCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPIdnTableCheckCmd.class);
    public static final String ELM_LOCALNAME = "check";
    public static final String ELM_NAME = "idnTable:check";
    private static final String ELM_TABLE = "table";
    private List<String> tables = new ArrayList<String>();
    private List<EPPIdnTableDomainLabel> domains = new ArrayList<EPPIdnTableDomainLabel>();

    public EPPIdnTableCheckCmd() {
    }

    public EPPIdnTableCheckCmd(String aTransId) {
        super(aTransId);
    }

    public EPPIdnTableCheckCmd(String aTransId, String aTable) {
        super(aTransId);
        this.addTable(aTable);
    }

    public EPPIdnTableCheckCmd(String aTransId, EPPIdnTableDomainLabel aDomain) {
        super(aTransId);
        this.addDomain(aDomain);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:idnTable-1.0";
    }

    public Form getForm() {
        if (this.hasDomains() && this.hasTables() || !this.hasDomains() && !this.hasTables()) {
            return Form.UNDEFINED_FORM;
        }
        if (this.hasDomains()) {
            return Form.DOMAIN_FORM;
        }
        return Form.TABLE_FORM;
    }

    public boolean hasTables() {
        return this.tables != null && !this.tables.isEmpty();
    }

    public List<String> getTables() {
        return this.tables;
    }

    public void setTables(List<String> aTables) {
        if (aTables == null) {
            this.tables = new ArrayList<String>();
        }
        this.tables = aTables;
    }

    public void setTable(String aTable) {
        this.tables = new ArrayList<String>();
        this.tables.add(aTable);
    }

    public void addTable(String aTable) {
        this.tables.add(aTable);
    }

    public boolean hasDomains() {
        return this.domains != null && !this.domains.isEmpty();
    }

    public List<EPPIdnTableDomainLabel> getDomains() {
        return this.domains;
    }

    public void setDomains(List<EPPIdnTableDomainLabel> aDomains) {
        if (aDomains == null) {
            this.domains = new ArrayList<EPPIdnTableDomainLabel>();
        }
        this.domains = aDomains;
    }

    public void setDomain(EPPIdnTableDomainLabel aDomain) {
        this.domains = new ArrayList<EPPIdnTableDomainLabel>();
        this.domains.add(aDomain);
    }

    public void addDomain(EPPIdnTableDomainLabel aDomain) {
        this.domains.add(aDomain);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.getForm() == Form.UNDEFINED_FORM) {
            throw new EPPEncodeException("Undefined form in EPPIdnTableCheckCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        EPPUtil.encodeList(aDocument, root, this.tables, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:table");
        EPPUtil.encodeCompList(aDocument, root, this.domains);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.tables = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_TABLE);
        this.domains = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:domain", EPPIdnTableDomainLabel.class);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPIdnTableCheckCmd theMap = (EPPIdnTableCheckCmd)aObject;
        if (!EPPUtil.equalLists(this.tables, theMap.tables)) {
            cat.error("EPPIdnTableCheckCmd.equals(): tables not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.domains, theMap.domains)) {
            cat.error("EPPIdnTableCheckCmd.equals(): domains not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableCheckCmd clone = (EPPIdnTableCheckCmd)super.clone();
        clone.tables = (List)((ArrayList)this.tables).clone();
        clone.domains = (List)((ArrayList)this.domains).clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public static enum Form {
        UNDEFINED_FORM,
        DOMAIN_FORM,
        TABLE_FORM;

    }
}

