/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EPPPurpose
implements EPPCodecComponent {
    static final String ELM_NAME = "purpose";
    private static final String ELM_ADMIN = "admin";
    private static final String ELM_CONTACT = "contact";
    private static final String ELM_OTHER = "other";
    private static final String ELM_PROV = "prov";
    private static Logger cat = LoggerFactory.getLogger(EPPPurpose.class);
    private boolean admin = false;
    private boolean contact = false;
    private boolean other = false;
    private boolean prov = false;

    public EPPPurpose() {
    }

    public EPPPurpose(boolean aAdmin, boolean aContact, boolean aOther, boolean aProv) {
        this.admin = aAdmin;
        this.contact = aContact;
        this.other = aOther;
        this.prov = aProv;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean aAdmin) {
        this.admin = aAdmin;
    }

    public boolean isContact() {
        return this.contact;
    }

    public void setContact(boolean aContact) {
        this.contact = aContact;
    }

    public boolean isOther() {
        return this.other;
    }

    public void setOther(boolean aOther) {
        this.other = aOther;
    }

    public boolean isProv() {
        return this.prov;
    }

    public void setProv(boolean aProv) {
        this.prov = aProv;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (!(this.admin || this.contact || this.other || this.prov)) {
            cat.error("EPPPurpose.encode(): At least one purpose must be set");
            throw new EPPEncodeException("EPPPurpose.encode(): At least one purpose must be set");
        }
        Element theElm = null;
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        if (this.admin) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_ADMIN);
            root.appendChild(theElm);
        }
        if (this.contact) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_CONTACT);
            root.appendChild(theElm);
        }
        if (this.other) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_OTHER);
            root.appendChild(theElm);
        }
        if (this.prov) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_PROV);
            root.appendChild(theElm);
        }
        return root;
    }

    private void reset() {
        this.admin = false;
        this.contact = false;
        this.other = false;
        this.prov = false;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        NodeList theList = aElement.getChildNodes();
        this.reset();
        for (int i = 0; i < theList.getLength(); ++i) {
            Node theNode = theList.item(i);
            if (theNode.getNodeType() != 1) continue;
            Element theElm = (Element)theNode;
            if (theElm.getLocalName().equals(EPPUtil.getLocalName(ELM_ADMIN))) {
                this.admin = true;
                continue;
            }
            if (theElm.getLocalName().equals(EPPUtil.getLocalName(ELM_CONTACT))) {
                this.contact = true;
                continue;
            }
            if (theElm.getLocalName().equals(EPPUtil.getLocalName(ELM_OTHER))) {
                this.other = true;
                continue;
            }
            if (theElm.getLocalName().equals(EPPUtil.getLocalName(ELM_PROV))) {
                this.prov = true;
                continue;
            }
            cat.error("EPPPurpose.decode(): Unknown element " + theElm);
            throw new EPPDecodeException("EPPPurpose.decode(): Unknown element " + theElm);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPPurpose)) {
            cat.error("EPPPurpose.equals(): " + aObject.getClass().getName() + " not EPPPurpose instance");
            return false;
        }
        EPPPurpose thePurpose = (EPPPurpose)aObject;
        if (this.admin != thePurpose.admin) {
            cat.error("EPPPurpose.equals(): admin not equal");
            return false;
        }
        if (this.contact != thePurpose.contact) {
            cat.error("EPPPurpose.equals(): contact not equal");
            return false;
        }
        if (this.other != thePurpose.other) {
            cat.error("EPPPurpose.equals(): other not equal");
            return false;
        }
        if (this.prov != thePurpose.prov) {
            cat.error("EPPPurpose.equals(): prov not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPPurpose clone = null;
        clone = (EPPPurpose)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }
}

