/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDcp;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPServiceMenu;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPGreeting
implements EPPMessage {
    public static final short MIN_SERVER_LEN = 3;
    public static final short MAX_SERVER_LEN = 64;
    static final String ELM_NAME = "greeting";
    private static final String ELM_SERVER = "svID";
    private static final String ELM_SERVER_DATE = "svDate";
    private static final String ELM_SERVICE_MENU = "svcMenu";
    private static Logger cat = LoggerFactory.getLogger(EPPGreeting.class);
    private String server;
    private Date serverDate;
    private EPPServiceMenu serviceMenu;
    private EPPDcp dcp;

    public EPPGreeting() {
        this.server = null;
        this.serverDate = new Date();
        this.serviceMenu = new EPPServiceMenu();
    }

    public EPPGreeting(String aServer, Date aServerDate, EPPServiceMenu aServiceMenu, EPPDcp aDcp) {
        this.server = aServer;
        this.serverDate = new Date();
        this.serviceMenu = aServiceMenu;
        this.dcp = aDcp;
    }

    public EPPGreeting(String aServer, Date aServerDate, EPPServiceMenu aServiceMenu) {
        this.server = aServer;
        this.serverDate = aServerDate;
        this.serviceMenu = aServiceMenu;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String aServer) {
        this.server = aServer;
    }

    public Date getServerDate() {
        return this.serverDate;
    }

    public void setServerDate(Date aServerDate) {
        this.serverDate = aServerDate;
    }

    public EPPServiceMenu getServiceMenu() {
        return this.serviceMenu;
    }

    public boolean hasService(String aNamespaceURI) {
        if (this.serviceMenu != null) {
            return this.serviceMenu.hasService(aNamespaceURI);
        }
        return false;
    }

    public boolean hasExtensionService(String aNamespaceURI) {
        if (this.serviceMenu != null) {
            return this.serviceMenu.hasExtensionService(aNamespaceURI);
        }
        return false;
    }

    public void setServiceMenu(EPPServiceMenu aServiceMenu) {
        this.serviceMenu = aServiceMenu;
    }

    public void setDcp(EPPDcp aDcp) {
        this.dcp = aDcp;
    }

    public EPPDcp getDcp() {
        return this.dcp;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        cat.debug("encode: enter");
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPGreeting.encode(): Invalid state");
            throw new EPPEncodeException("EPPGreeting invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.server, "urn:ietf:params:xml:ns:epp-1.0", ELM_SERVER);
        EPPUtil.encodeTimeInstant(aDocument, root, this.serverDate, "urn:ietf:params:xml:ns:epp-1.0", ELM_SERVER_DATE);
        EPPUtil.encodeComp(aDocument, root, this.serviceMenu);
        if (this.dcp != null) {
            EPPUtil.encodeComp(aDocument, root, this.dcp);
        }
        cat.debug("encode: exit");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        cat.debug("decode: enter");
        this.serverDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_SERVER_DATE);
        this.server = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_SERVER);
        this.serviceMenu = (EPPServiceMenu)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_SERVICE_MENU, EPPServiceMenu.class);
        this.dcp = (EPPDcp)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp-1.0", "dcp", EPPDcp.class);
        cat.debug("decode: exit");
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPGreeting)) {
            cat.error("EPPGreeting.equals(): " + aObject.getClass().getName() + " not EPPGreeting instance");
            return false;
        }
        EPPGreeting theGreeting = (EPPGreeting)aObject;
        if (!this.server.equals(theGreeting.server)) {
            cat.error("EPPGreeting.equals(): server not equal");
            return false;
        }
        if (!this.serverDate.equals(theGreeting.serverDate)) {
            cat.error("EPPGreeting.equals(): serverDate not equal");
            return false;
        }
        if (!this.serviceMenu.equals(theGreeting.serviceMenu)) {
            cat.error("EPPGreeting.equals(): serviceMenu not equal");
            return false;
        }
        if (!this.dcp.equals(theGreeting.dcp)) {
            cat.error("EPPGreeting.equals(): dcp not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPGreeting clone = null;
        clone = (EPPGreeting)super.clone();
        clone.serviceMenu = (EPPServiceMenu)this.serviceMenu.clone();
        clone.dcp = (EPPDcp)this.dcp.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    private void validateState() throws EPPCodecException {
        if (this.server == null) {
            cat.error("EPPGreeting.validateState(): server is null");
            throw new EPPCodecException("Required attribute \"server\" is null");
        }
        if (this.server.length() < 3 || this.server.length() > 64) {
            cat.error("EPPGreeting.validateState(): Invalid server attribute length of " + this.server.length());
            throw new EPPCodecException("Invalid server attribute length of " + this.server.length());
        }
    }
}

