/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.util.TestThread;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EPPEncodeDecodeStats {
    private String name;
    private long xmlIterations = 0L;
    private int xmlSize = 0;
    private long xmlStartTime = 0L;
    private long xmlEndTime = 0L;
    private long xmlTotalTime = 0L;
    private byte[] xmlFormat = null;
    private boolean xmlValidating = false;
    private long serialIterations = 0L;
    private int serialSize = 0;
    private long serialStartTime = 0L;
    private long serialEndTime = 0L;
    private long serialTotalTime = 0L;

    public EPPEncodeDecodeStats(EPPMessage aMessage) {
        this.name = "Message: " + aMessage.getClass().getName();
    }

    public EPPEncodeDecodeStats(String aName) {
        this.name = aName;
    }

    public boolean isXmlValidating() {
        return this.xmlValidating;
    }

    void setXmlValidating(boolean aXmlValidating) {
        this.xmlValidating = aXmlValidating;
    }

    public String getName() {
        return this.name;
    }

    void setName(String aName) {
        this.name = aName;
    }

    public void startXmlTimer() {
        this.xmlStartTime = System.currentTimeMillis();
    }

    public void stopXmlTimer() {
        if (this.xmlStartTime != 0L) {
            this.xmlEndTime = System.currentTimeMillis();
            this.xmlTotalTime += this.xmlEndTime - this.xmlStartTime;
            this.xmlStartTime = 0L;
            ++this.xmlIterations;
        }
    }

    public long getXmlTotalTime() {
        return this.xmlTotalTime;
    }

    public long getXmlIterations() {
        return this.xmlIterations;
    }

    public int getXmlSize() {
        return this.xmlSize;
    }

    public void setXmlSize(int aXmlSize) {
        this.xmlSize = aXmlSize;
    }

    public byte[] getXmlFormat() {
        return this.xmlFormat;
    }

    public void setXmlFormat(byte[] aXmlFormat) {
        this.xmlFormat = aXmlFormat;
        this.xmlSize = this.xmlFormat.length;
    }

    public void startSerialTimer() {
        this.serialStartTime = System.currentTimeMillis();
    }

    public void stopSerialTimer() {
        if (this.serialStartTime != 0L) {
            this.serialEndTime = System.currentTimeMillis();
            this.serialTotalTime += this.serialEndTime - this.serialStartTime;
            this.serialStartTime = 0L;
            ++this.serialIterations;
        }
    }

    public long getSerialTotalTime() {
        return this.serialTotalTime;
    }

    public long getSerialIterations() {
        return this.serialIterations;
    }

    public int getSerialSize() {
        return this.serialSize;
    }

    public void setSerialSize(int aSerialSize) {
        this.serialSize = aSerialSize;
    }

    public String toString() {
        ByteArrayOutputStream ret = new ByteArrayOutputStream();
        try {
            PrintWriter writer = new PrintWriter(ret);
            writer.println("");
            if (Thread.currentThread() instanceof TestThread) {
                writer.println(Thread.currentThread().getName() + ": " + this.name);
            } else {
                writer.println(this.name);
            }
            writer.println("-------------------------------------------------------------------------------------");
            writer.println("");
            if (this.xmlFormat != null) {
                writer.println("XML Format:");
                writer.flush();
                ret.write(this.xmlFormat);
                writer.println("");
                writer.println("");
            }
            writer.println("XML Size:                  " + this.xmlSize + " bytes");
            writer.println("XML Iterations:            " + this.xmlIterations);
            writer.println("XML Validating:            " + this.xmlValidating);
            writer.println("XML Total Time:            " + this.xmlTotalTime + " milliseconds");
            if (this.xmlIterations != 0L) {
                writer.println("XML Time per Iteration:    " + this.xmlTotalTime / this.xmlIterations + " milliseconds");
            }
            writer.println("Serial Size:               " + this.serialSize + " bytes");
            writer.println("Serial Iterations:         " + this.serialIterations);
            writer.println("Serial Total Time:         " + this.serialTotalTime + " milliseconds");
            if (this.serialIterations != 0L) {
                writer.println("Serial Time per Iteration: " + this.serialTotalTime / this.serialIterations + " milliseconds");
            }
            writer.println("");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret.toString();
    }
}

