/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.host.EPPHostAddress;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPHostAttr
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "hostAttr";
    public static final String ELM_NAME = "domain:hostAttr";
    private static final String ELM_HOST_NAME = "hostName";
    private static final String ELM_ADDRESS = "hostAddr";
    private String name = null;
    private Vector<EPPHostAddress> addresses = null;

    public EPPHostAttr() {
    }

    public EPPHostAttr(String aName) {
        this.name = aName;
    }

    public EPPHostAttr(String aName, Vector<EPPHostAddress> aAddresses) {
        this.name = aName;
        this.setAddresses(aAddresses);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasAddresses() {
        return this.addresses != null;
    }

    public void addAddress(EPPHostAddress aAddress) {
        if (aAddress == null) {
            return;
        }
        aAddress.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:hostAddr");
        if (this.addresses == null) {
            this.addresses = new Vector();
        }
        this.addresses.add(aAddress);
    }

    public Vector<EPPHostAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Vector<EPPHostAddress> aAddresses) {
        this.addresses = aAddresses;
        if (this.addresses != null) {
            for (EPPHostAddress currAddress : this.addresses) {
                currAddress.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:hostAddr");
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPHostAttr clone = (EPPHostAttr)super.clone();
        if (this.addresses != null) {
            clone.addresses = (Vector)this.addresses.clone();
            for (int i = 0; i < this.addresses.size(); ++i) {
                clone.addresses.setElementAt((EPPHostAddress)this.addresses.elementAt(i).clone(), i);
            }
        }
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_NAME);
        this.addresses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_ADDRESS, EPPHostAddress.class);
        if (this.addresses.size() == 0) {
            this.addresses = null;
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("EPPHostAttr: Host name is required");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", "domain:hostName");
        EPPUtil.encodeCompVector(aDocument, root, this.addresses);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostAttr)) {
            return false;
        }
        EPPHostAttr theComp = (EPPHostAttr)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        return EPPUtil.equalVectors(this.addresses, theComp.addresses);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }
}

