/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.coaext;

import com.verisign.epp.codec.coaext.EPPCoaExtKey;
import com.verisign.epp.codec.coaext.EPPCoaExtValue;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPCoaExtAttr
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = LoggerFactory.getLogger(EPPCoaExtAttr.class);
    public static final String ELM_NAME = "coa:attr";
    private EPPCoaExtKey key = null;
    private EPPCoaExtValue value = null;

    public EPPCoaExtAttr() {
    }

    public EPPCoaExtAttr(String aKey, String aValue) {
        this.key = new EPPCoaExtKey(aKey);
        this.value = new EPPCoaExtValue(aValue);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPCoaExtAttr theClone = (EPPCoaExtAttr)super.clone();
        if (this.getKey() != null) {
            theClone.setKey((EPPCoaExtKey)this.getKey().clone());
        }
        if (this.getValue() != null) {
            theClone.setValue((EPPCoaExtValue)this.getValue().clone());
        }
        return theClone;
    }

    public boolean equals(Object aComp) {
        if (!(aComp instanceof EPPCoaExtAttr)) {
            return false;
        }
        EPPCoaExtAttr theComp = (EPPCoaExtAttr)aComp;
        if (this.getKey() == null) {
            return false;
        }
        if (!this.getKey().equals(theComp.getKey())) {
            return false;
        }
        if (this.getValue() == null && theComp.getValue() != null) {
            return false;
        }
        return this.getValue().equals(theComp.getValue());
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.key = (EPPCoaExtKey)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:coa-1.0", "coa:key", EPPCoaExtKey.class);
        this.value = (EPPCoaExtValue)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:coa-1.0", "coa:value", EPPCoaExtValue.class);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPCoaExtAttr.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPCoaExtAttr.encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPCoaExtAttr invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:coa-1.0", ELM_NAME);
        root.appendChild(this.key.encode(aDocument));
        root.appendChild(this.value.encode(aDocument));
        return root;
    }

    private void validateState() throws EPPCodecException {
        if (this.key == null) {
            throw new EPPCodecException("EPPCoaExtAttr required element key is not set");
        }
        if (this.value == null) {
            throw new EPPCodecException("EPPCoaExtAttr required element value is not set");
        }
    }

    public EPPCoaExtKey getKey() {
        return this.key;
    }

    public void setKey(EPPCoaExtKey aKey) {
        this.key = aKey;
    }

    public EPPCoaExtValue getValue() {
        return this.value;
    }

    public void setValue(EPPCoaExtValue aValue) {
        this.value = aValue;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:coa-1.0";
    }
}

