/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.changepoll;

import com.verisign.epp.codec.changepoll.EPPChangeCaseId;
import com.verisign.epp.codec.changepoll.EPPChangeOperation;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPChangeData
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPChangeData.class);
    public static final String ELM_LOCALNAME = "changeData";
    public static final String ELM_NAME = "changePoll:changeData";
    public static final String STATE_BEFORE = "before";
    public static final String STATE_AFTER = "after";
    private static final String ATTR_STATE = "state";
    private static final String ELM_DATE = "date";
    private static final String ELM_SVRTRID = "svTRID";
    private static final String ELM_WHO = "who";
    private static final String ELM_REASON = "reason";
    private static final String ATTR_LANG = "lang";
    private String state = "after";
    private EPPChangeOperation operation;
    private Date date;
    private String svrTrid;
    private String who;
    private EPPChangeCaseId caseId;
    private String reason;
    private String reasonLang;

    public EPPChangeData() {
    }

    public EPPChangeData(EPPChangeOperation aOperation, Date aDate, String aSvrTrid, String aWho) {
        this.setOperation(aOperation);
        this.setDate(aDate);
        this.setSvrTrid(aSvrTrid);
        this.setWho(aWho);
    }

    public EPPChangeData(EPPChangeOperation aOperation, Date aDate, String aSvrTrid, String aWho, String aState, EPPChangeCaseId aCaseId, String aReason, String aReasonLang) {
        this.setOperation(aOperation);
        this.setDate(aDate);
        this.setSvrTrid(aSvrTrid);
        this.setWho(aWho);
        this.setState(aState);
        this.setCaseId(aCaseId);
        this.setReason(aReason);
        this.setReasonLang(aReasonLang);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String aState) {
        this.state = aState;
    }

    public EPPChangeOperation getOperation() {
        return this.operation;
    }

    public void setOperation(EPPChangeOperation aOperation) {
        this.operation = aOperation;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date aDate) {
        this.date = aDate;
    }

    public String getSvrTrid() {
        return this.svrTrid;
    }

    public void setSvrTrid(String aSvrTrid) {
        this.svrTrid = aSvrTrid;
    }

    public String getWho() {
        return this.who;
    }

    public void setWho(String aWho) {
        this.who = aWho;
    }

    public boolean hasCaseId() {
        return this.caseId != null;
    }

    public EPPChangeCaseId getCaseId() {
        return this.caseId;
    }

    public void setCaseId(EPPChangeCaseId aCaseId) {
        this.caseId = aCaseId;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    public boolean hasReasonLang() {
        return this.reasonLang != null;
    }

    public String getReasonLang() {
        return this.reasonLang;
    }

    public void setReasonLang(String aReasonLang) {
        this.reasonLang = aReasonLang;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:changePoll-1.0", ELM_NAME);
        if (this.state != null) {
            root.setAttribute(ATTR_STATE, this.state);
        }
        EPPUtil.encodeComp(aDocument, root, this.operation);
        EPPUtil.encodeTimeInstant(aDocument, root, this.date, "urn:ietf:params:xml:ns:changePoll-1.0", "changePoll:date");
        EPPUtil.encodeString(aDocument, root, this.svrTrid, "urn:ietf:params:xml:ns:changePoll-1.0", "changePoll:svTRID");
        EPPUtil.encodeString(aDocument, root, this.who, "urn:ietf:params:xml:ns:changePoll-1.0", "changePoll:who");
        EPPUtil.encodeComp(aDocument, root, this.caseId);
        if (this.hasReason()) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:changePoll-1.0", "changePoll:reason");
            if (this.hasReasonLang()) {
                reasonElm.setAttribute(ATTR_LANG, this.reasonLang);
            }
            reasonElm.appendChild(aDocument.createTextNode(this.reason));
            root.appendChild(reasonElm);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theState = aElement.getAttribute(ATTR_STATE);
        this.state = theState != null && !theState.isEmpty() ? theState : STATE_AFTER;
        this.operation = (EPPChangeOperation)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:changePoll-1.0", "changePoll:operation", EPPChangeOperation.class);
        this.date = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:changePoll-1.0", ELM_DATE);
        this.svrTrid = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:changePoll-1.0", ELM_SVRTRID);
        this.who = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:changePoll-1.0", ELM_WHO);
        this.caseId = (EPPChangeCaseId)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:changePoll-1.0", "changePoll:caseId", EPPChangeCaseId.class);
        Element theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:changePoll-1.0", ELM_REASON);
        if (theReasonElm != null) {
            Node textNode = theReasonElm.getFirstChild();
            if (textNode != null) {
                this.reason = textNode.getNodeValue();
                String theReasonLang = theReasonElm.getAttribute(ATTR_LANG);
                this.reasonLang = theReasonLang != null && !theReasonLang.isEmpty() ? theReasonLang : null;
            } else {
                this.reason = null;
                this.reasonLang = null;
            }
        } else {
            this.reason = null;
            this.reasonLang = null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPChangeData clone = (EPPChangeData)super.clone();
        if (this.operation != null) {
            clone.operation = (EPPChangeOperation)this.operation.clone();
        }
        if (this.caseId != null) {
            clone.caseId = (EPPChangeCaseId)this.caseId.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPChangeData)) {
            return false;
        }
        EPPChangeData other = (EPPChangeData)aObject;
        if (!EqualityUtil.equals(this.state, other.state)) {
            cat.error("EPPChangeData.equals(): state not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.operation, other.operation)) {
            cat.error("EPPChangeData.equals(): operation not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.date, other.date)) {
            cat.error("EPPChangeData.equals(): date not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.svrTrid, other.svrTrid)) {
            cat.error("EPPChangeData.equals(): svrTrid not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.who, other.who)) {
            cat.error("EPPChangeData.equals(): who not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.caseId, other.caseId)) {
            cat.error("EPPChangeData.equals(): caseId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, other.reason)) {
            cat.error("EPPChangeData.equals(): reason not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reasonLang, other.reasonLang)) {
            cat.error("EPPChangeData.equals(): reasonLang not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:changePoll-1.0";
    }
}

