/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.changepoll;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPChangeCaseId
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPChangeCaseId.class);
    public static final String TYPE_UDRP = "udrp";
    public static final String TYPE_URS = "urs";
    public static final String TYPE_CUSTOM = "custom";
    public static final String ELM_LOCALNAME = "caseId";
    public static final String ELM_NAME = "changePoll:caseId";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";
    private String identifier;
    private String type;
    private String name;

    public EPPChangeCaseId() {
    }

    public EPPChangeCaseId(String aIdentifier, String aType) {
        this.identifier = aIdentifier;
        this.type = aType;
    }

    public EPPChangeCaseId(String aIdentifier, String aType, String aName) {
        this.identifier = aIdentifier;
        this.type = aType;
        this.name = aName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setValue(String aIdentifier) {
        this.identifier = aIdentifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPChangeCaseId clone = null;
        clone = (EPPChangeCaseId)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theType = aElement.getAttribute(ATTR_TYPE);
        this.type = theType != null && !theType.isEmpty() ? theType : null;
        String theName = aElement.getAttribute(ATTR_NAME);
        this.name = theName != null && !theName.isEmpty() ? theName : null;
        Node textNode = aElement.getFirstChild();
        if (textNode != null) {
            this.identifier = textNode.getNodeValue();
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPChangeCaseId.encode(Document)");
        }
        if (this.identifier == null) {
            throw new EPPEncodeException("identifier is null in EPPChangeCaseId.encode(Document)");
        }
        if (this.type == null) {
            throw new EPPEncodeException("type is null in EPPChangeCaseId.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:changePoll-1.0", ELM_NAME);
        if (this.type != null) {
            root.setAttribute(ATTR_TYPE, this.type);
        }
        if (this.name != null) {
            root.setAttribute(ATTR_NAME, this.name);
        }
        Text phaseText = aDocument.createTextNode(this.identifier);
        root.appendChild(phaseText);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPChangeCaseId)) {
            return false;
        }
        EPPChangeCaseId other = (EPPChangeCaseId)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error("EPPChangeCaseId.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPChangeCaseId.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.identifier, other.identifier)) {
            cat.error("EPPChangeCaseId.equals(): identifier not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:changePoll-1.0";
    }
}

