/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/

package com.verisign.epp.serverstub.validate.v02;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckCmd;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckResp;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckResult;
import com.verisign.epp.codec.validate.v02.EPPValidateKeyValue;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.validate.v02.EPPValidateHandler;


/**
 * The <code>ValidateHandler</code> class extends
 * <code>EPPValidateHandler</code> to include handling the validate check
 * command.
 */
public class ValidateHandler extends EPPValidateHandler {

	/** Category for logging */
	    private static Logger cat = LoggerFactory.getLogger(ValidateHandler.class);
	      

	/**
	 * Constructs an instance of ValidateHandler
	 */
	public ValidateHandler() {
	}

	/**
	 * Will ensure that the namestore extension is provided.
	 *
	 * @param aEvent
	 *           The <code>EPPEvent</code> that is being handled
	 * @param aData
	 *           Any data that a Server needs to send to this
	 *           <code>EPPDomainHandler</code> This is assumed to be an instance
	 *           of SessionData here.
	 *
	 * @exception EPPHandleEventException
	 *               Thrown if an error condition occurs. It must contain an
	 *               <code>EPPEventResponse</code>
	 */
	@Override
	protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {

		super.preHandleEvent(aEvent, aData);

	}

	/**
	 * Override base handler <code>doValidateCheck</code> method and add handling
	 * of the Allocation Token Extension.
	 *
	 * @param aEvent
	 *           The <code>EPPEvent</code> that is being handled
	 * @param aData
	 *           Any data that a Server needs to send to this
	 *           <code>EPPDomaindHandler</code>
	 *
	 * @return EPPEventResponse The response that should be sent back to the
	 *         client.
	 */
	@Override
	protected EPPEventResponse doValidateCheck(EPPEvent aEvent, Object aData) {

		EPPValidateCheckCmd theCommand = (EPPValidateCheckCmd) aEvent.getMessage();

		EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");

		EPPValidateCheckResp theResp = new EPPValidateCheckResp(theTransId);

		// sh8013 validate check data
		theResp.addResult(new EPPValidateCheckResult("sh8013", EPPResult.SUCCESS));

		// sh8014 validate check data
		EPPValidateCheckResult theResult = new EPPValidateCheckResult("sh8014", EPPResult.PARAM_VALUE_POLICY_ERROR);
		theResult.addKeyValue(new EPPValidateKeyValue("contact:city", "City not valid for state."));
		theResult
		      .addKeyValue(new EPPValidateKeyValue("contact:cc", "Invalid country code for admin, must be mx.", "Admin"));
		theResult.addKeyValue(new EPPValidateKeyValue("VAT", "VAT required for Billing contact.", "Billing"));
		theResp.addResult(theResult);

		EPPEventResponse theEventResponse = new EPPEventResponse(theResp);

		return theEventResponse;
	}

}
