/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-0107  USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/

package com.verisign.epp.codec.org;

/**
 * Statuses of the organization role, with one of the following values:<br>
 * <ul>
 * <li><code>ok</code> - This is the normal status value for an role that has no
 * pending operations or prohibitions. This value is set and removed by the
 * server as other status values are added or removed.</li>
 * <li><code>linked</code> - The role of an organization object has at least one
 * active association with another object. The "linked" status is not explicitly
 * set by the client. Servers SHOULD provide services to determine existing
 * object associations.</li>
 * <li><code>clientLinkProhibited</code> or
 * <code>serverLinkProhibited</code> - Requests to add new links to the
 * organization MUST be rejected.</li>
 * </ul>
 */
public enum EPPOrgRoleStatus implements java.io.Serializable,Cloneable {
	ok, linked, clientLinkProhibited, serverLinkProhibited;
}